/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui;

import java.io.File;
import javax.swing.filechooser.FileFilter;
import org.locationtech.jts.jump.workbench.ui.GUIUtil;

public class WorkbenchFileFilter
extends FileFilter {
    private String description;

    public WorkbenchFileFilter(String fileType) {
        this.description = fileType;
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        String extension = GUIUtil.getExtension(file);
        if (extension != null) {
            if (this.description.equals("JCS GML")) {
                return extension.equals("jml") || extension.equals("zip") || extension.equals("gz");
            }
            if (this.description.equals("XML")) {
                return extension.equals("xml") || extension.equals("zip") || extension.equals("gz");
            }
            if (this.description.equals("ESRI Shapefile")) {
                return extension.equals("shp") || extension.equals("zip");
            }
            if (this.description.equals("SHX")) {
                return extension.equals("shx");
            }
            if (this.description.equals("DBF")) {
                return extension.equals("dbf");
            }
            if (this.description.equals("GML")) {
                return extension.equals("gml") || extension.equals("fme") || extension.equals("zip") || extension.equals("gz");
            }
            if (this.description.equals("Well Known Text")) {
                return extension.equals("wkt") || extension.equals("zip") || extension.equals("gz");
            }
            if (this.description.equals("FME GML")) {
                return extension.equals("xml") || extension.equals("fme") || extension.equals("zip") || extension.equals("gz");
            }
        }
        return false;
    }

    @Override
    public String getDescription() {
        return this.description;
    }
}

