/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.jump.util.Block;
import org.locationtech.jts.jump.util.CollectionUtil;
import org.locationtech.jts.jump.util.StringUtil;
import org.locationtech.jts.jump.workbench.WorkbenchContext;
import org.locationtech.jts.jump.workbench.model.Category;
import org.locationtech.jts.jump.workbench.model.CategoryEvent;
import org.locationtech.jts.jump.workbench.model.FeatureEvent;
import org.locationtech.jts.jump.workbench.model.Layer;
import org.locationtech.jts.jump.workbench.model.LayerEvent;
import org.locationtech.jts.jump.workbench.model.LayerEventType;
import org.locationtech.jts.jump.workbench.model.LayerListener;
import org.locationtech.jts.jump.workbench.model.LayerManager;
import org.locationtech.jts.jump.workbench.model.LayerManagerProxy;
import org.locationtech.jts.jump.workbench.model.Layerable;
import org.locationtech.jts.jump.workbench.model.Task;
import org.locationtech.jts.jump.workbench.model.UndoableEditReceiver;
import org.locationtech.jts.jump.workbench.model.WMSLayer;
import org.locationtech.jts.jump.workbench.plugin.AbstractPlugIn;
import org.locationtech.jts.jump.workbench.plugin.EnableCheck;
import org.locationtech.jts.jump.workbench.plugin.PlugIn;
import org.locationtech.jts.jump.workbench.ui.ApplicationExitHandler;
import org.locationtech.jts.jump.workbench.ui.ErrorDialog;
import org.locationtech.jts.jump.workbench.ui.GUIUtil;
import org.locationtech.jts.jump.workbench.ui.HTMLFrame;
import org.locationtech.jts.jump.workbench.ui.InternalFrameCloseHandler;
import org.locationtech.jts.jump.workbench.ui.LayerNamePanel;
import org.locationtech.jts.jump.workbench.ui.LayerNamePanelListener;
import org.locationtech.jts.jump.workbench.ui.LayerNamePanelProxy;
import org.locationtech.jts.jump.workbench.ui.LayerViewPanelContext;
import org.locationtech.jts.jump.workbench.ui.LayerViewPanelListener;
import org.locationtech.jts.jump.workbench.ui.PrimaryInfoFrame;
import org.locationtech.jts.jump.workbench.ui.RecursiveKeyListener;
import org.locationtech.jts.jump.workbench.ui.TaskFrame;
import org.locationtech.jts.jump.workbench.ui.TitledPopupMenu;
import org.locationtech.jts.jump.workbench.ui.ViewportListener;
import org.locationtech.jts.jump.workbench.ui.WorkbenchToolBar;
import org.locationtech.jts.jump.workbench.ui.plugin.CloneWindowPlugIn;
import org.locationtech.jts.jump.workbench.ui.plugin.FeatureInstaller;
import org.locationtech.jts.jump.workbench.ui.renderer.style.ChoosableStyle;
import org.locationtech.jts.jump.workbench.ui.task.TaskMonitorManager;
import org.locationtech.jts.util.Assert;

public class WorkbenchFrame
extends JFrame
implements LayerViewPanelContext,
ViewportListener {
    BorderLayout borderLayout1 = new BorderLayout();
    JLabel coordinateLabel = new JLabel();
    JMenuBar menuBar = new JMenuBar();
    JMenu fileMenu = (JMenu)FeatureInstaller.installMnemonic(new JMenu("File"), this.menuBar);
    JMenuItem exitMenuItem = FeatureInstaller.installMnemonic(new JMenuItem("E&xit"), this.fileMenu);
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JLabel messageLabel = new JLabel();
    JPanel statusPanel = new JPanel();
    JLabel timeLabel = new JLabel();
    WorkbenchToolBar toolBar;
    JMenu windowMenu = (JMenu)FeatureInstaller.installMnemonic(new JMenu("Window"), this.menuBar);
    private TitledPopupMenu categoryPopupMenu = new TitledPopupMenu(){
        {
            this.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    LayerNamePanel panel = ((LayerNamePanelProxy)((Object)WorkbenchFrame.this.getActiveInternalFrame())).getLayerNamePanel();
                    this.setTitle(panel.selectedNodes(Category.class).size() != 1 ? "(" + panel.selectedNodes(Category.class).size() + " categories selected)" : ((Category)panel.selectedNodes(Category.class).iterator().next()).getName());
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }
            });
        }
    };
    private JDesktopPane desktopPane = new JDesktopPane();
    private int envelopeRenderingThreshold = 500;
    private HTMLFrame outputFrame = new HTMLFrame(this){
        {
            super.setTitle("Output");
        }

        @Override
        public void setTitle(String title) {
        }
    };
    private ImageIcon icon;
    private TitledPopupMenu layerNamePopupMenu = new TitledPopupMenu(){
        {
            this.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    LayerNamePanel panel = ((LayerNamePanelProxy)((Object)WorkbenchFrame.this.getActiveInternalFrame())).getLayerNamePanel();
                    this.setTitle(panel.selectedNodes(Layer.class).size() != 1 ? "(" + panel.selectedNodes(Layer.class).size() + " layers selected)" : ((Layerable)panel.selectedNodes(Layer.class).iterator().next()).getName());
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }
            });
        }
    };
    private TitledPopupMenu wmsLayerNamePopupMenu = new TitledPopupMenu(){
        {
            this.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    LayerNamePanel panel = ((LayerNamePanelProxy)((Object)WorkbenchFrame.this.getActiveInternalFrame())).getLayerNamePanel();
                    this.setTitle(panel.selectedNodes(WMSLayer.class).size() != 1 ? "(" + panel.selectedNodes(WMSLayer.class).size() + " WMS layers selected)" : ((Layerable)panel.selectedNodes(WMSLayer.class).iterator().next()).getName());
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }
            });
        }
    };
    private LayerNamePanelListener layerNamePanelListener = new LayerNamePanelListener(){

        @Override
        public void layerSelectionChanged() {
            WorkbenchFrame.this.toolBar.updateEnabledState();
        }
    };
    private LayerViewPanelListener layerViewPanelListener = new LayerViewPanelListener(){
        private StringBuffer positionStatusBuf = new StringBuffer("(");

        @Override
        public void cursorPositionChanged(String x, String y) {
            this.positionStatusBuf.setLength(1);
            this.positionStatusBuf.append(x).append(", ").append(y).append(")");
            WorkbenchFrame.this.coordinateLabel.setText(this.positionStatusBuf.toString());
        }

        @Override
        public void selectionChanged() {
            WorkbenchFrame.this.toolBar.updateEnabledState();
        }

        public void fenceChanged() {
            WorkbenchFrame.this.toolBar.updateEnabledState();
        }

        @Override
        public void painted(Graphics graphics) {
        }
    };
    private int maximumFeatureExtentForEnvelopeRenderingInPixels = 10;
    private int minimumFeatureExtentForAnyRenderingInPixels = 2;
    private StringBuffer log = new StringBuffer();
    private int taskSequence = 1;
    private WorkbenchContext workbenchContext;
    private JLabel memoryLabel = new JLabel();
    private String lastStatusMessage = "";
    private Set choosableStyleClasses = new HashSet();
    private JLabel wmsLabel = new JLabel();
    private ArrayList easyKeyListeners = new ArrayList();
    private Map nodeClassToLayerNamePopupMenuMap = CollectionUtil.createMap(new Object[]{Layer.class, this.layerNamePopupMenu, WMSLayer.class, this.wmsLayerNamePopupMenu, Category.class, this.categoryPopupMenu});
    private int positionIndex = -1;
    private int primaryInfoFrameIndex = -1;
    private ArrayList lastFiveThrowableDates = new ArrayList(){

        @Override
        public boolean add(Object o) {
            if (this.size() == 5) {
                this.remove(0);
            }
            return super.add(o);
        }
    };
    private HashMap keyCodeAndModifiersToPlugInAndEnableCheckMap = new HashMap();
    InternalFrameCloseHandler internalFrameCloseHandler = new DefaultInternalFrameCloser();
    ApplicationExitHandler applicationExitHandler = new DefaultApplicationExitHandler();

    public WorkbenchFrame(String title, ImageIcon icon, WorkbenchContext workbenchContext) throws Exception {
        this.setTitle(title);
        new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkbenchFrame.this.memoryLabel.setText(WorkbenchFrame.this.getMBCommittedMemory() + " MB Committed Memory");
                WorkbenchFrame.this.memoryLabel.setToolTipText(LayerManager.layerManagerCount() + " Layer Manager" + StringUtil.s(LayerManager.layerManagerCount()));
            }
        }).start();
        this.workbenchContext = workbenchContext;
        this.icon = icon;
        this.toolBar = new WorkbenchToolBar(workbenchContext);
        try {
            this.jbInit();
            this.configureStatusLabel(this.messageLabel, 300);
            this.configureStatusLabel(this.coordinateLabel, 150);
            this.configureStatusLabel(this.timeLabel, 200);
            this.configureStatusLabel(this.wmsLabel, 100);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        new RecursiveKeyListener(this){

            @Override
            public void keyTyped(KeyEvent e) {
                for (KeyListener l : WorkbenchFrame.this.easyKeyListeners) {
                    l.keyTyped(e);
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
                for (KeyListener l : new ArrayList(WorkbenchFrame.this.easyKeyListeners)) {
                    l.keyPressed(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                for (KeyListener l : new ArrayList(WorkbenchFrame.this.easyKeyListeners)) {
                    l.keyReleased(e);
                }
            }
        };
        this.installKeyboardShortcutListener();
    }

    public void addEasyKeyListener(KeyListener l) {
        this.easyKeyListeners.add(l);
    }

    public void removeEasyKeyListener(KeyListener l) {
        this.easyKeyListeners.remove(l);
    }

    public String getMBCommittedMemory() {
        return new DecimalFormat("###,###").format((double)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1048576.0);
    }

    public void setEnvelopeRenderingThreshold(int newEnvelopeRenderingThreshold) {
        this.envelopeRenderingThreshold = newEnvelopeRenderingThreshold;
    }

    public void setMaximumFeatureExtentForEnvelopeRenderingInPixels(int newMaximumFeatureExtentForEnvelopeRenderingInPixels) {
        this.maximumFeatureExtentForEnvelopeRenderingInPixels = newMaximumFeatureExtentForEnvelopeRenderingInPixels;
    }

    public void log(String message) {
        this.log.append(new Date() + "  " + message + System.getProperty("line.separator"));
    }

    public String getLog() {
        return this.log.toString();
    }

    public void setMinimumFeatureExtentForAnyRenderingInPixels(int newMinimumFeatureExtentForAnyRenderingInPixels) {
        this.minimumFeatureExtentForAnyRenderingInPixels = newMinimumFeatureExtentForAnyRenderingInPixels;
    }

    public void displayLastStatusMessage() {
        this.setStatusMessage(this.lastStatusMessage);
    }

    @Override
    public void setStatusMessage(String message) {
        this.lastStatusMessage = message;
        this.setStatusBarText(message);
        this.setStatusBarTextHighlighted(false, null);
    }

    private void setStatusBarText(String message) {
        this.messageLabel.setText(message == "" ? " " : message);
        this.messageLabel.setToolTipText(message);
    }

    private void setStatusBarTextHighlighted(boolean highlighted, Color color) {
        this.messageLabel.setForeground(highlighted ? Color.black : this.coordinateLabel.getForeground());
        this.messageLabel.setBackground(highlighted ? color : this.coordinateLabel.getBackground());
    }

    public void setTimeMessage(String message) {
        this.timeLabel.setText(message == "" ? " " : message);
    }

    public JInternalFrame getActiveInternalFrame() {
        return this.desktopPane.getSelectedFrame();
    }

    public JInternalFrame[] getInternalFrames() {
        return this.desktopPane.getAllFrames();
    }

    public TitledPopupMenu getCategoryPopupMenu() {
        return this.categoryPopupMenu;
    }

    public WorkbenchContext getContext() {
        return this.workbenchContext;
    }

    public JDesktopPane getDesktopPane() {
        return this.desktopPane;
    }

    public int getEnvelopeRenderingThreshold() {
        return this.envelopeRenderingThreshold;
    }

    public TitledPopupMenu getLayerNamePopupMenu() {
        return this.layerNamePopupMenu;
    }

    public TitledPopupMenu getWMSLayerNamePopupMenu() {
        return this.wmsLayerNamePopupMenu;
    }

    public LayerViewPanelListener getLayerViewPanelListener() {
        return this.layerViewPanelListener;
    }

    public Map getNodeClassToPopupMenuMap() {
        return this.nodeClassToLayerNamePopupMenuMap;
    }

    public LayerNamePanelListener getLayerNamePanelListener() {
        return this.layerNamePanelListener;
    }

    public int getMaximumFeatureExtentForEnvelopeRenderingInPixels() {
        return this.maximumFeatureExtentForEnvelopeRenderingInPixels;
    }

    public int getMinimumFeatureExtentForAnyRenderingInPixels() {
        return this.minimumFeatureExtentForAnyRenderingInPixels;
    }

    public HTMLFrame getOutputFrame() {
        return this.outputFrame;
    }

    public WorkbenchToolBar getToolBar() {
        return this.toolBar;
    }

    public void activateFrame(JInternalFrame frame) {
        try {
            if (frame.isIcon()) {
                frame.setIcon(false);
            }
            frame.moveToFront();
            frame.requestFocus();
            frame.setSelected(true);
            if (!(frame instanceof TaskFrame)) {
                frame.setMaximum(false);
            }
        }
        catch (PropertyVetoException e) {
            this.warnUser(StringUtil.stackTrace(e));
        }
    }

    public void addInternalFrame(JInternalFrame internalFrame) {
        this.addInternalFrame(internalFrame, false, true);
    }

    public void addInternalFrame(JInternalFrame internalFrame, boolean alwaysOnTop, boolean autoUpdateToolBar) {
        if (internalFrame instanceof LayerManagerProxy) {
            this.setClosingBehaviour((LayerManagerProxy)((Object)internalFrame));
            this.installTitleBarModifiedIndicator((LayerManagerProxy)((Object)internalFrame));
        }
        internalFrame.setFrameIcon(this.icon);
        internalFrame.setVisible(true);
        this.desktopPane.add((Component)internalFrame, alwaysOnTop ? JLayeredPane.PALETTE_LAYER : JLayeredPane.DEFAULT_LAYER);
        if (autoUpdateToolBar) {
            internalFrame.addInternalFrameListener(new InternalFrameListener(){

                @Override
                public void internalFrameActivated(InternalFrameEvent e) {
                    WorkbenchFrame.this.toolBar.updateEnabledState();
                    WorkbenchFrame.this.toolBar.reClickSelectedCursorToolButton();
                }

                @Override
                public void internalFrameClosed(InternalFrameEvent e) {
                    WorkbenchFrame.this.toolBar.updateEnabledState();
                }

                @Override
                public void internalFrameClosing(InternalFrameEvent e) {
                    WorkbenchFrame.this.toolBar.updateEnabledState();
                }

                @Override
                public void internalFrameDeactivated(InternalFrameEvent e) {
                    WorkbenchFrame.this.toolBar.updateEnabledState();
                }

                @Override
                public void internalFrameDeiconified(InternalFrameEvent e) {
                    WorkbenchFrame.this.toolBar.updateEnabledState();
                }

                @Override
                public void internalFrameIconified(InternalFrameEvent e) {
                    WorkbenchFrame.this.toolBar.updateEnabledState();
                }

                @Override
                public void internalFrameOpened(InternalFrameEvent e) {
                    WorkbenchFrame.this.toolBar.updateEnabledState();
                }
            });
            this.activateFrame(internalFrame);
            this.position(internalFrame);
        }
    }

    private void installTitleBarModifiedIndicator(final LayerManagerProxy internalFrame) {
        final JInternalFrame i = (JInternalFrame)((Object)internalFrame);
        new Block(){
            private boolean updatingTitle = false;

            private void updateTitle() {
                if (this.updatingTitle) {
                    return;
                }
                this.updatingTitle = true;
                try {
                    String newTitle = i.getTitle();
                    if (newTitle.charAt(0) == '*') {
                        newTitle = newTitle.substring(1);
                    }
                    if (!internalFrame.getLayerManager().getLayersWithModifiedFeatureCollections().isEmpty()) {
                        newTitle = '*' + newTitle;
                    }
                    i.setTitle(newTitle);
                }
                finally {
                    this.updatingTitle = false;
                }
            }

            @Override
            public Object yield() {
                internalFrame.getLayerManager().addLayerListener(new LayerListener(){

                    @Override
                    public void layerChanged(LayerEvent e) {
                        if (e.getType() == LayerEventType.METADATA_CHANGED || e.getType() == LayerEventType.REMOVED) {
                            this.updateTitle();
                        }
                    }

                    @Override
                    public void categoryChanged(CategoryEvent e) {
                    }

                    @Override
                    public void featuresChanged(FeatureEvent e) {
                    }
                });
                i.addPropertyChangeListener("title", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent e) {
                        this.updateTitle();
                    }
                });
                return null;
            }
        }.yield();
    }

    private void setClosingBehaviour(LayerManagerProxy proxy) {
        final JInternalFrame internalFrame = (JInternalFrame)((Object)proxy);
        internalFrame.setDefaultCloseOperation(0);
        internalFrame.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosing(InternalFrameEvent e) {
                WorkbenchFrame.this.internalFrameCloseHandler.close(internalFrame);
            }
        });
    }

    private Collection getInternalFramesAssociatedWith(LayerManager layerManager) {
        ArrayList<JInternalFrame> internalFramesAssociatedWithLayerManager = new ArrayList<JInternalFrame>();
        JInternalFrame[] internalFrames = this.getInternalFrames();
        for (int i = 0; i < internalFrames.length; ++i) {
            if (!(internalFrames[i] instanceof LayerManagerProxy) || ((LayerManagerProxy)((Object)internalFrames[i])).getLayerManager() != layerManager) continue;
            internalFramesAssociatedWithLayerManager.add(internalFrames[i]);
        }
        return internalFramesAssociatedWithLayerManager;
    }

    public TaskFrame addTaskFrame() {
        TaskFrame f = this.addTaskFrame(this.createTask());
        return f;
    }

    public Task createTask() {
        Task task = new Task();
        task.getLayerManager().addCategory("Working");
        task.getLayerManager().addCategory("System");
        task.setName("Task " + this.taskSequence++);
        return task;
    }

    public TaskFrame addTaskFrame(Task task) {
        return this.addTaskFrame(new TaskFrame(task, this.workbenchContext));
    }

    public TaskFrame addTaskFrame(TaskFrame taskFrame) {
        taskFrame.getTask().getLayerManager().addLayerListener(new LayerListener(){

            @Override
            public void featuresChanged(FeatureEvent e) {
            }

            @Override
            public void categoryChanged(CategoryEvent e) {
                WorkbenchFrame.this.toolBar.updateEnabledState();
            }

            @Override
            public void layerChanged(LayerEvent layerEvent) {
                WorkbenchFrame.this.toolBar.updateEnabledState();
            }
        });
        this.addInternalFrame(taskFrame);
        taskFrame.getLayerViewPanel().getLayerManager().getUndoableEditReceiver().add(new UndoableEditReceiver.Listener(){

            @Override
            public void undoHistoryChanged() {
                WorkbenchFrame.this.toolBar.updateEnabledState();
            }

            @Override
            public void undoHistoryTruncated() {
                WorkbenchFrame.this.toolBar.updateEnabledState();
                WorkbenchFrame.this.log("Undo history was truncated");
            }
        });
        return taskFrame;
    }

    public void flash(final HTMLFrame frame) {
        final Color originalColor = frame.getBackgroundColor();
        new Timer(100, new ActionListener(){
            private int tickCount = 0;

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ++this.tickCount;
                    frame.setBackgroundColor(this.tickCount % 2 == 0 ? originalColor : Color.yellow);
                    if (this.tickCount == 2) {
                        Timer timer = (Timer)e.getSource();
                        timer.stop();
                    }
                }
                catch (Throwable t) {
                    WorkbenchFrame.this.handleThrowable(t);
                }
            }
        }).start();
    }

    private void flashStatusMessage(final String message, final Color color) {
        new Timer(100, new ActionListener(){
            private int tickCount = 0;

            @Override
            public void actionPerformed(ActionEvent e) {
                ++this.tickCount;
                WorkbenchFrame.this.setStatusBarText(message);
                WorkbenchFrame.this.setStatusBarTextHighlighted(this.tickCount % 2 == 0, color);
                if (this.tickCount == 4) {
                    Timer timer = (Timer)e.getSource();
                    timer.stop();
                }
            }
        }).start();
    }

    @Override
    public void handleThrowable(Throwable t) {
        this.log(StringUtil.stackTrace(t));
        Window parent = this;
        Window[] ownedWindows = this.getOwnedWindows();
        for (int i = 0; i < ownedWindows.length; ++i) {
            if (!(ownedWindows[i] instanceof Dialog) || !ownedWindows[i].isVisible() || !((Dialog)ownedWindows[i]).isModal()) continue;
            parent = ownedWindows[i];
            break;
        }
        WorkbenchFrame.handleThrowable(t, parent);
    }

    public static void handleThrowable(final Throwable t, final Component parent) {
        t.printStackTrace(System.err);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ErrorDialog.show(parent, StringUtil.toFriendlyName(t.getClass().getName()), WorkbenchFrame.toMessage(t), StringUtil.stackTrace(t));
            }
        });
    }

    public static String toMessage(Throwable t) {
        String message = t.getLocalizedMessage() == null ? "No description was provided" : (t.getLocalizedMessage().toLowerCase().indexOf("side location conflict") > -1 ? t.getLocalizedMessage() + " -- Check for invalid geometries." : t.getLocalizedMessage());
        return message + " (" + StringUtil.toFriendlyName(t.getClass().getName()) + ")";
    }

    public boolean hasInternalFrame(JInternalFrame internalFrame) {
        JInternalFrame[] frames = this.desktopPane.getAllFrames();
        for (int i = 0; i < frames.length; ++i) {
            if (frames[i] != internalFrame) continue;
            return true;
        }
        return false;
    }

    public void removeInternalFrame(JInternalFrame internalFrame) {
        this.desktopPane.getDesktopManager().closeFrame(internalFrame);
    }

    @Override
    public void warnUser(String warning) {
        this.log("Warning: " + warning);
        this.flashStatusMessage(warning, Color.yellow);
    }

    @Override
    public void zoomChanged(Envelope modelEnvelope) {
        this.toolBar.updateEnabledState();
    }

    void exitMenuItem_actionPerformed(ActionEvent e) {
        this.closeApplication();
    }

    void this_componentShown(ComponentEvent e) {
        try {
            this.toolBar.updateEnabledState();
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
    }

    void this_windowClosing(WindowEvent e) {
        this.closeApplication();
    }

    void windowMenu_menuSelected(MenuEvent e) {
        if (this.windowMenu.getItemCount() > 0 && this.windowMenu.getItem(0) != null && this.windowMenu.getItem(0).getText().equals(AbstractPlugIn.createName(CloneWindowPlugIn.class))) {
            JMenuItem newWindowMenuItem = this.windowMenu.getItem(0);
            this.windowMenu.removeAll();
            this.windowMenu.add(newWindowMenuItem);
            this.windowMenu.addSeparator();
        } else {
            this.windowMenu.removeAll();
        }
        JInternalFrame[] frames = this.desktopPane.getAllFrames();
        for (int i = 0; i < frames.length; ++i) {
            JMenuItem menuItem = new JMenuItem();
            menuItem.setText(GUIUtil.truncateString(frames[i].getTitle(), 40));
            this.associate(menuItem, frames[i]);
            this.windowMenu.add(menuItem);
        }
        if (this.windowMenu.getItemCount() == 0) {
            this.windowMenu.add(new JMenuItem("(No Windows)"));
        }
    }

    private void associate(JMenuItem menuItem, final JInternalFrame frame) {
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    WorkbenchFrame.this.activateFrame(frame);
                }
                catch (Throwable t) {
                    WorkbenchFrame.this.handleThrowable(t);
                }
            }
        });
    }

    private void closeApplication() {
        this.applicationExitHandler.exitApplication(this);
    }

    private Collection getLayersWithModifiedFeatureCollections() {
        ArrayList layersWithModifiedFeatureCollections = new ArrayList();
        for (LayerManager layerManager : this.getLayerManagers()) {
            layersWithModifiedFeatureCollections.addAll(layerManager.getLayersWithModifiedFeatureCollections());
        }
        return layersWithModifiedFeatureCollections;
    }

    private Collection getLayerManagers() {
        HashSet<LayerManager> layerManagers = new HashSet<LayerManager>();
        JInternalFrame[] internalFrames = this.getInternalFrames();
        for (int i = 0; i < internalFrames.length; ++i) {
            if (!(internalFrames[i] instanceof LayerManagerProxy)) continue;
            layerManagers.add(((LayerManagerProxy)((Object)internalFrames[i])).getLayerManager());
        }
        return layerManagers;
    }

    private void configureStatusLabel(JLabel label, int width) {
        label.setMinimumSize(new Dimension(width, (int)label.getMinimumSize().getHeight()));
        label.setMaximumSize(new Dimension(width, (int)label.getMaximumSize().getHeight()));
        label.setPreferredSize(new Dimension(width, (int)label.getPreferredSize().getHeight()));
    }

    private void jbInit() throws Exception {
        this.setDefaultCloseOperation(0);
        this.setIconImage(this.icon.getImage());
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                WorkbenchFrame.this.this_componentShown(e);
            }
        });
        this.getContentPane().setLayout(this.borderLayout1);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                WorkbenchFrame.this.this_windowClosing(e);
            }
        });
        this.setJMenuBar(this.menuBar);
        this.setSize(900, 665);
        this.messageLabel.setOpaque(true);
        this.memoryLabel.setText("jLabel1");
        this.wmsLabel.setHorizontalAlignment(2);
        this.wmsLabel.setText(" ");
        this.getContentPane().add((Component)this.statusPanel, "South");
        this.exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkbenchFrame.this.exitMenuItem_actionPerformed(e);
            }
        });
        this.windowMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent e) {
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuSelected(MenuEvent e) {
                WorkbenchFrame.this.windowMenu_menuSelected(e);
            }
        });
        this.coordinateLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.wmsLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.coordinateLabel.setText(" ");
        this.statusPanel.setLayout(this.gridBagLayout1);
        this.statusPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        this.messageLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.messageLabel.setText(" ");
        this.timeLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.timeLabel.setText(" ");
        this.memoryLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.memoryLabel.setText(" ");
        this.menuBar.add(this.fileMenu);
        this.menuBar.add(this.windowMenu);
        this.getContentPane().add((Component)this.toolBar, "North");
        this.getContentPane().add((Component)this.desktopPane, "Center");
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.exitMenuItem);
        this.statusPanel.add((Component)this.coordinateLabel, new GridBagConstraints(5, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.statusPanel.add((Component)this.timeLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.statusPanel.add((Component)this.messageLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.statusPanel.add((Component)this.memoryLabel, new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.statusPanel.add((Component)this.wmsLabel, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void position(JInternalFrame internalFrame) {
        int STEP = 5;
        GUIUtil.Location location = null;
        if (internalFrame instanceof PrimaryInfoFrame) {
            ++this.primaryInfoFrameIndex;
            int offset = this.primaryInfoFrameIndex % 3 * 5;
            location = new GUIUtil.Location(offset, true, offset, true);
        } else {
            ++this.positionIndex;
            int offset = this.positionIndex % 5 * 5;
            location = new GUIUtil.Location(offset, false, offset, false);
        }
        GUIUtil.setLocation(internalFrame, location, this.desktopPane);
    }

    public Set getChoosableStyleClasses() {
        return Collections.unmodifiableSet(this.choosableStyleClasses);
    }

    public void addChoosableStyleClass(Class choosableStyleClass) {
        Assert.isTrue((boolean)ChoosableStyle.class.isAssignableFrom(choosableStyleClass));
        this.choosableStyleClasses.add(choosableStyleClass);
    }

    public void addKeyboardShortcut(int keyCode, int modifiers, PlugIn plugIn, EnableCheck enableCheck) {
        this.keyCodeAndModifiersToPlugInAndEnableCheckMap.put(keyCode + ":" + modifiers, new Object[]{plugIn, enableCheck});
    }

    private void installKeyboardShortcutListener() {
        this.addEasyKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                Object[] plugInAndEnableCheck = (Object[])WorkbenchFrame.this.keyCodeAndModifiersToPlugInAndEnableCheckMap.get(e.getKeyCode() + ":" + e.getModifiers());
                if (plugInAndEnableCheck == null) {
                    return;
                }
                PlugIn plugIn = (PlugIn)plugInAndEnableCheck[0];
                EnableCheck enableCheck = (EnableCheck)plugInAndEnableCheck[1];
                if (enableCheck != null && enableCheck.check(null) != null) {
                    return;
                }
                AbstractPlugIn.toActionListener(plugIn, WorkbenchFrame.this.workbenchContext, new TaskMonitorManager()).actionPerformed(null);
            }
        });
    }

    public InternalFrameCloseHandler getInternalFrameCloseHandler() {
        return this.internalFrameCloseHandler;
    }

    public void setInternalFrameCloseHandler(InternalFrameCloseHandler value) {
        this.internalFrameCloseHandler = value;
    }

    public ApplicationExitHandler getApplicationExitHandler() {
        return this.applicationExitHandler;
    }

    public void setApplicationExitHandler(ApplicationExitHandler value) {
        this.applicationExitHandler = value;
    }

    private void closeTaskFrame(TaskFrame taskFrame) {
        LayerManager layerManager = taskFrame.getLayerManager();
        if (this.getInternalFramesAssociatedWith(layerManager).size() == 1) {
            Collection modifiedItems = layerManager.getLayersWithModifiedFeatureCollections();
            if (this.confirmClose("Close Task", modifiedItems)) {
                GUIUtil.dispose(taskFrame, this.desktopPane);
                layerManager.dispose();
            }
        } else {
            GUIUtil.dispose(taskFrame, this.desktopPane);
        }
    }

    private boolean confirmClose(String action, Collection modifiedLayers) {
        if (modifiedLayers.isEmpty()) {
            return true;
        }
        JOptionPane pane = new JOptionPane(StringUtil.split(modifiedLayers.size() + " dataset" + StringUtil.s(modifiedLayers.size()) + " " + (modifiedLayers.size() > 1 ? "have" : "has") + " been modified (" + (modifiedLayers.size() > 3 ? "e.g. " : "") + StringUtil.toCommaDelimitedString(new ArrayList(modifiedLayers).subList(0, Math.min(3, modifiedLayers.size()))) + "). Continue?", 80), 2);
        pane.setOptions(new String[]{action, "Cancel"});
        pane.createDialog(this, "JUMP").setVisible(true);
        return pane.getValue().equals(action);
    }

    private class DefaultApplicationExitHandler
    implements ApplicationExitHandler {
        private DefaultApplicationExitHandler() {
        }

        @Override
        public void exitApplication(JFrame mainFrame) {
            if (WorkbenchFrame.this.confirmClose("Exit JUMP", WorkbenchFrame.this.getLayersWithModifiedFeatureCollections())) {
                WorkbenchFrame.this.setVisible(false);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        System.exit(0);
                    }
                });
            }
        }
    }

    private class DefaultInternalFrameCloser
    implements InternalFrameCloseHandler {
        private DefaultInternalFrameCloser() {
        }

        @Override
        public void close(JInternalFrame internalFrame) {
            if (internalFrame instanceof TaskFrame) {
                WorkbenchFrame.this.closeTaskFrame((TaskFrame)internalFrame);
            } else {
                GUIUtil.dispose(internalFrame, WorkbenchFrame.this.desktopPane);
            }
        }
    }
}

