/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import org.locationtech.jts.jump.workbench.WorkbenchContext;
import org.locationtech.jts.jump.workbench.plugin.AbstractPlugIn;
import org.locationtech.jts.jump.workbench.plugin.EnableCheck;
import org.locationtech.jts.jump.workbench.plugin.PlugIn;
import org.locationtech.jts.jump.workbench.ui.EnableableToolBar;
import org.locationtech.jts.jump.workbench.ui.LayerViewPanelProxy;
import org.locationtech.jts.jump.workbench.ui.cursortool.CursorTool;
import org.locationtech.jts.jump.workbench.ui.cursortool.QuasimodeTool;
import org.locationtech.jts.jump.workbench.ui.task.TaskMonitorManager;
import org.locationtech.jts.util.Assert;

public class WorkbenchToolBar
extends EnableableToolBar {
    private HashMap cursorToolClassToButtonMap = new HashMap();
    private LayerViewPanelProxy layerViewPanelProxy;
    private TaskMonitorManager taskMonitorManager = null;
    private EnableCheck cursorToolEnableCheck = new EnableCheck(){

        @Override
        public String check(JComponent component) {
            return null;
        }
    };
    private ButtonGroup cursorToolButtonGroup;

    public AbstractButton getButton(Class cursorToolClass) {
        Assert.isTrue((boolean)CursorTool.class.isAssignableFrom(cursorToolClass));
        return (AbstractButton)this.cursorToolClassToButtonMap.get(cursorToolClass);
    }

    public WorkbenchToolBar(LayerViewPanelProxy layerViewPanelProxy) {
        this(layerViewPanelProxy, new ButtonGroup());
    }

    public WorkbenchToolBar(LayerViewPanelProxy layerViewPanelProxy, ButtonGroup cursorToolButtonGroup) {
        this.cursorToolButtonGroup = cursorToolButtonGroup;
        this.layerViewPanelProxy = layerViewPanelProxy;
    }

    public void setCursorToolEnableCheck(EnableCheck cursorToolEnableCheck) {
        this.cursorToolEnableCheck = cursorToolEnableCheck;
    }

    public void setTaskMonitorManager(TaskMonitorManager taskMonitorManager) {
        this.taskMonitorManager = taskMonitorManager;
    }

    public ToolConfig addCursorTool(final CursorTool cursorTool) {
        return this.addCursorTool(cursorTool.getName(), cursorTool, new JToggleButton(){

            @Override
            public String getToolTipText(MouseEvent event) {
                return cursorTool.getName();
            }
        });
    }

    public ToolConfig addCursorTool(String tooltip, CursorTool cursorTool) {
        JToggleButton button = new JToggleButton();
        return this.addCursorTool(tooltip, cursorTool, button);
    }

    private ToolConfig addCursorTool(String tooltip, CursorTool cursorTool, JToggleButton button) {
        this.cursorToolButtonGroup.add(button);
        this.cursorToolClassToButtonMap.put(cursorTool.getClass(), button);
        final QuasimodeTool quasimodeTool = QuasimodeTool.addStandardQuasimodes(cursorTool);
        this.add(button, tooltip, cursorTool.getIcon(), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WorkbenchToolBar.this.layerViewPanelProxy.getLayerViewPanel() != null) {
                    WorkbenchToolBar.this.layerViewPanelProxy.getLayerViewPanel().setCurrentCursorTool(quasimodeTool);
                }
            }
        }, this.cursorToolEnableCheck);
        if (this.cursorToolButtonGroup.getButtonCount() == 1) {
            this.cursorToolButtonGroup.setSelected(button.getModel(), true);
            this.reClickSelectedCursorToolButton();
        }
        return new ToolConfig(button, quasimodeTool);
    }

    public ButtonGroup getButtonGroup() {
        return this.cursorToolButtonGroup;
    }

    public JToggleButton getSelectedCursorToolButton() {
        Enumeration<AbstractButton> e = this.cursorToolButtonGroup.getElements();
        while (e.hasMoreElements()) {
            JToggleButton button = (JToggleButton)e.nextElement();
            if (button.getModel() != this.cursorToolButtonGroup.getSelection()) continue;
            return button;
        }
        Assert.shouldNeverReachHere();
        return null;
    }

    public void reClickSelectedCursorToolButton() {
        if (this.cursorToolButtonGroup.getButtonCount() == 0) {
            return;
        }
        this.getSelectedCursorToolButton().doClick();
    }

    public JButton addPlugIn(Icon icon, PlugIn plugIn, EnableCheck enableCheck, WorkbenchContext workbenchContext) {
        JButton button = new JButton();
        this.add(button, plugIn.getName(), icon, AbstractPlugIn.toActionListener(plugIn, workbenchContext, this.taskMonitorManager), enableCheck);
        return button;
    }

    public static class ToolConfig {
        private JToggleButton button;
        private QuasimodeTool quasimodeTool;

        public ToolConfig(JToggleButton button, QuasimodeTool quasimodeTool) {
            this.button = button;
            this.quasimodeTool = quasimodeTool;
        }

        public JToggleButton getButton() {
            return this.button;
        }

        public QuasimodeTool getQuasimodeTool() {
            return this.quasimodeTool;
        }
    }
}

