/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui.addremove;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.locationtech.jts.jump.workbench.ui.InputChangedFirer;
import org.locationtech.jts.jump.workbench.ui.InputChangedListener;
import org.locationtech.jts.jump.workbench.ui.JListTypeAheadKeyListener;
import org.locationtech.jts.jump.workbench.ui.addremove.AddRemoveList;
import org.locationtech.jts.jump.workbench.ui.addremove.AddRemoveListModel;
import org.locationtech.jts.jump.workbench.ui.addremove.DefaultAddRemoveListModel;

public class DefaultAddRemoveList
extends JPanel
implements AddRemoveList {
    private BorderLayout borderLayout1 = new BorderLayout();
    private JList list = new JList();
    private DefaultAddRemoveListModel model;
    private InputChangedFirer inputChangedFirer = new InputChangedFirer();
    private Border border1;

    public DefaultAddRemoveList() {
        this(new DefaultListModel());
    }

    @Override
    public void add(MouseListener listener) {
        this.list.addMouseListener(listener);
    }

    public DefaultAddRemoveList(DefaultListModel listModel) {
        this.model = new DefaultAddRemoveListModel(listModel);
        this.list.setModel(listModel);
        this.list.addKeyListener(new JListTypeAheadKeyListener(this.list));
        this.list.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DefaultAddRemoveList.this.inputChangedFirer.fire();
            }
        });
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void setSelectedItems(Collection items) {
        ArrayList<Integer> indicesToSelect = new ArrayList<Integer>();
        for (Object item : items) {
            int index = this.getModel().getItems().indexOf(item);
            if (index == -1) continue;
            indicesToSelect.add(new Integer(index));
        }
        int[] indexArray = new int[indicesToSelect.size()];
        for (int i = 0; i < indicesToSelect.size(); ++i) {
            Integer index = (Integer)indicesToSelect.get(i);
            indexArray[i] = index;
        }
        this.list.setSelectedIndices(indexArray);
    }

    @Override
    public AddRemoveListModel getModel() {
        return this.model;
    }

    @Override
    public void add(InputChangedListener listener) {
        this.inputChangedFirer.add(listener);
    }

    public JList getList() {
        return this.list;
    }

    @Override
    public List getSelectedItems() {
        return Arrays.asList(this.list.getSelectedValues());
    }

    void jbInit() throws Exception {
        this.border1 = new EtchedBorder(0, new Color(0, 0, 51), new Color(0, 0, 25));
        this.setLayout(this.borderLayout1);
        this.add((Component)this.list, "Center");
    }
}

