/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui.addremove;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.ListModel;
import org.locationtech.jts.jump.workbench.ui.addremove.AddRemoveListModel;

public class DefaultAddRemoveListModel
implements AddRemoveListModel {
    private DefaultListModel listModel;
    private boolean sorted = false;

    public DefaultAddRemoveListModel(DefaultListModel listModel) {
        this.listModel = listModel;
    }

    public ListModel getListModel() {
        return this.listModel;
    }

    @Override
    public void add(Object item) {
        this.listModel.addElement(item);
        if (this.sorted) {
            this.sort();
        }
    }

    private void setItemsWithoutSorting(Collection items) {
        this.listModel.clear();
        Iterator i = items.iterator();
        while (i.hasNext()) {
            this.listModel.addElement(i.next());
        }
    }

    @Override
    public void setItems(Collection items) {
        this.setItemsWithoutSorting(items);
        if (this.sorted) {
            this.sort();
        }
    }

    private void sort() {
        ArrayList items = new ArrayList(this.getItems());
        Collections.sort(items);
        this.setItemsWithoutSorting(items);
    }

    @Override
    public List getItems() {
        return Arrays.asList(this.listModel.toArray());
    }

    public void setSorted(boolean sorted) {
        this.sorted = sorted;
    }

    @Override
    public void remove(Object item) {
        this.listModel.removeElement(item);
    }
}

