/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui.cursortool;

import java.awt.Cursor;
import java.awt.geom.NoninvertibleTransformException;
import javax.swing.Icon;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.jump.workbench.model.FenceLayerFinder;
import org.locationtech.jts.jump.workbench.ui.cursortool.DrawRectangleFenceTool;
import org.locationtech.jts.jump.workbench.ui.cursortool.PolygonTool;
import org.locationtech.jts.jump.workbench.ui.images.IconLoader;

public class DrawPolygonFenceTool
extends PolygonTool {
    public DrawPolygonFenceTool() {
        this.setColor(DrawRectangleFenceTool.COLOR);
    }

    @Override
    public Cursor getCursor() {
        return DrawPolygonFenceTool.createCursor(IconLoader.icon("FenceCursor.gif").getImage());
    }

    @Override
    public Icon getIcon() {
        return IconLoader.icon("Box.gif");
    }

    private boolean doubleClicked() {
        return this.getCoordinates().size() == 1;
    }

    @Override
    protected void gestureFinished() throws NoninvertibleTransformException {
        Polygon fence;
        this.reportNothingToUndoYet();
        if (this.doubleClicked()) {
            fence = null;
        } else {
            if (!this.checkPolygon()) {
                return;
            }
            this.getPanel().setViewportInitialized(true);
            fence = this.getPolygon();
        }
        FenceLayerFinder fenceLayerFinder = new FenceLayerFinder(this.getPanel());
        fenceLayerFinder.setFence((Geometry)fence);
        if (!fenceLayerFinder.getLayer().isVisible()) {
            fenceLayerFinder.getLayer().setVisible(true);
        }
    }
}

