/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui.cursortool;

import java.awt.Color;
import java.awt.Cursor;
import java.util.Collection;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.locationtech.jts.jump.workbench.model.Layer;
import org.locationtech.jts.jump.workbench.ui.InfoFrame;
import org.locationtech.jts.jump.workbench.ui.cursortool.SpecifyFeaturesTool;
import org.locationtech.jts.jump.workbench.ui.images.IconLoader;

public class FeatureInfoTool
extends SpecifyFeaturesTool {
    public static final ImageIcon ICON = IconLoader.icon("Info.gif");

    public FeatureInfoTool() {
        this.setColor(Color.magenta);
    }

    @Override
    public Icon getIcon() {
        return ICON;
    }

    @Override
    public Cursor getCursor() {
        return FeatureInfoTool.createCursor(IconLoader.icon("InfoCursor.gif").getImage());
    }

    @Override
    protected void gestureFinished() throws Exception {
        this.reportNothingToUndoYet();
        InfoFrame infoFrame = this.getTaskFrame().getInfoFrame();
        if (!this.wasShiftPressed()) {
            infoFrame.getModel().clear();
        }
        Map map = this.layerToSpecifiedFeaturesMap();
        for (Layer layer : map.keySet()) {
            if (layer.getName().equals("Fence")) continue;
            Collection features = (Collection)map.get(layer);
            infoFrame.getModel().add(layer, features);
        }
        infoFrame.surface();
    }
}

