/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui.cursortool;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.geom.NoninvertibleTransformException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.jump.workbench.ui.LayerViewPanel;
import org.locationtech.jts.jump.workbench.ui.cursortool.MultiClickTool;
import org.locationtech.jts.jump.workbench.ui.images.IconLoader;

public class MeasureTool
extends MultiClickTool {
    public MeasureTool() {
        this.allowSnapping();
    }

    @Override
    public Icon getIcon() {
        return IconLoader.icon("Ruler.gif");
    }

    @Override
    public Cursor getCursor() {
        return MeasureTool.createCursor(IconLoader.icon("RulerCursor.gif").getImage());
    }

    @Override
    public void mouseLocationChanged(MouseEvent e) {
        try {
            if (this.isShapeOnScreen()) {
                ArrayList<Coordinate> currentCoordinates = new ArrayList<Coordinate>(this.getCoordinates());
                currentCoordinates.add(this.getPanel().getViewport().toModelCoordinate(e.getPoint()));
                this.display(currentCoordinates, this.getPanel());
            }
            super.mouseLocationChanged(e);
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    @Override
    protected void gestureFinished() throws NoninvertibleTransformException {
        this.reportNothingToUndoYet();
        this.display(this.getCoordinates(), this.getPanel());
    }

    private void display(List coordinates, LayerViewPanel panel) throws NoninvertibleTransformException {
        this.display(this.distance(coordinates), panel);
    }

    private void display(double distance, LayerViewPanel panel) {
        panel.getContext().setStatusMessage("Distance: " + panel.format(distance));
    }

    private double distance(List coordinates) {
        double distance = 0.0;
        for (int i = 1; i < coordinates.size(); ++i) {
            distance += ((Coordinate)coordinates.get(i - 1)).distance((Coordinate)coordinates.get(i));
        }
        return distance;
    }
}

