/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui.cursortool.editing;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.geom.NoninvertibleTransformException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.jump.feature.Feature;
import org.locationtech.jts.jump.geom.CoordUtil;
import org.locationtech.jts.jump.util.CoordinateArrays;
import org.locationtech.jts.jump.workbench.model.Layer;
import org.locationtech.jts.jump.workbench.plugin.EnableCheckFactory;
import org.locationtech.jts.jump.workbench.ui.EditTransaction;
import org.locationtech.jts.jump.workbench.ui.GeometryEditor;
import org.locationtech.jts.jump.workbench.ui.cursortool.Animations;
import org.locationtech.jts.jump.workbench.ui.cursortool.NClickTool;
import org.locationtech.jts.jump.workbench.ui.images.IconLoader;
import org.locationtech.jts.util.Assert;

public class InsertVertexTool
extends NClickTool {
    private static final int PIXEL_RANGE = 5;
    private EnableCheckFactory checkFactory;

    public InsertVertexTool(EnableCheckFactory checkFactory) {
        super(1);
        this.checkFactory = checkFactory;
    }

    private double modelRange() {
        return 5.0 / this.getPanel().getViewport().getScale();
    }

    private Collection featuresInRange(Coordinate modelClickCoordinate, Layer layer) {
        Point modelClickPoint = new GeometryFactory().createPoint(modelClickCoordinate);
        Collection featuresWithSelectedItems = this.getPanel().getSelectionManager().getFeaturesWithSelectedItems(layer);
        if (featuresWithSelectedItems.isEmpty()) {
            return new ArrayList();
        }
        ArrayList<Feature> featuresInRange = new ArrayList<Feature>();
        for (Feature candidate : featuresWithSelectedItems) {
            if (!(modelClickPoint.distance(candidate.getGeometry()) <= this.modelRange())) continue;
            featuresInRange.add(candidate);
        }
        return featuresInRange;
    }

    private Coordinate modelClickCoordinate() throws NoninvertibleTransformException {
        return (Coordinate)this.getCoordinates().get(0);
    }

    private LineSegment segmentInRange(Geometry geometry, Coordinate target) {
        LineSegment closest = null;
        List coordArrays = CoordinateArrays.toCoordinateArrays(geometry, false);
        for (Coordinate[] coordinates : coordArrays) {
            for (int j = 1; j < coordinates.length; ++j) {
                LineSegment candidate = new LineSegment(coordinates[j - 1], coordinates[j]);
                if (candidate.distance(target) > this.modelRange() || closest != null && !(candidate.distance(target) < closest.distance(target))) continue;
                closest = candidate;
            }
        }
        return closest;
    }

    private Coordinate newVertex(LineSegment segment, Coordinate target) {
        Coordinate closestPoint = segment.closestPoint(target);
        if (!closestPoint.equals((Object)segment.p0) && !closestPoint.equals((Object)segment.p1)) {
            return closestPoint;
        }
        double threshold = 6.0 / this.getPanel().getViewport().getScale();
        if (segment.getLength() < threshold) {
            return CoordUtil.average(segment.p0, segment.p1);
        }
        double offset = 3.0 / this.getPanel().getViewport().getScale();
        Coordinate unitVector = closestPoint.equals((Object)segment.p0) ? CoordUtil.divide(CoordUtil.subtract(segment.p1, segment.p0), segment.getLength()) : CoordUtil.divide(CoordUtil.subtract(segment.p0, segment.p1), segment.getLength());
        return CoordUtil.add(closestPoint, CoordUtil.multiply(offset, unitVector));
    }

    private SegmentContext findSegment(Layer layer, Collection features, Coordinate target) {
        Assert.isTrue((boolean)layer.isEditable());
        for (Feature feature : features) {
            for (Geometry selectedItem : this.getPanel().getSelectionManager().getSelectedItems(layer, feature)) {
                LineSegment segment = this.segmentInRange(selectedItem, target);
                if (segment == null) continue;
                return new SegmentContext(layer, feature, segment);
            }
        }
        return null;
    }

    private SegmentContext findSegment(Map layerToFeaturesMap, Coordinate target) {
        for (Layer layer : layerToFeaturesMap.keySet()) {
            Collection features;
            SegmentContext segmentContext = this.findSegment(layer, features = (Collection)layerToFeaturesMap.get(layer), target);
            if (segmentContext == null) continue;
            return segmentContext;
        }
        return null;
    }

    @Override
    protected void gestureFinished() throws Exception {
        this.reportNothingToUndoYet();
        if (!this.check(this.checkFactory.createAtLeastNItemsMustBeSelectedCheck(1))) {
            return;
        }
        if (!this.check(this.checkFactory.createAtLeastNLayersMustBeEditableCheck(1))) {
            return;
        }
        HashMap layerToFeaturesInRangeMap = this.layerToFeaturesInRangeMap();
        if (layerToFeaturesInRangeMap.isEmpty()) {
            this.getPanel().getContext().warnUser("No selected editable items here");
            return;
        }
        SegmentContext segment = this.findSegment(layerToFeaturesInRangeMap, this.modelClickCoordinate());
        if (segment == null) {
            this.getPanel().getContext().warnUser("No selected line segments here");
            return;
        }
        Coordinate newVertex = this.newVertex(segment.getSegment(), this.modelClickCoordinate());
        Geometry newGeometry = new GeometryEditor().insertVertex(segment.getFeature().getGeometry(), segment.getSegment().p0, segment.getSegment().p1, newVertex);
        this.gestureFinished(newGeometry, newVertex, segment);
    }

    protected void gestureFinished(Geometry newGeometry, final Coordinate newVertex, SegmentContext segment) {
        EditTransaction transaction = new EditTransaction(Arrays.asList(segment.getFeature()), this.getName(), segment.getLayer(), this.isRollingBackInvalidEdits(), false, this.getPanel());
        transaction.setGeometry(0, newGeometry);
        transaction.commit(new EditTransaction.SuccessAction(){

            @Override
            public void run() {
                try {
                    Animations.drawExpandingRing(InsertVertexTool.this.getPanel().getViewport().toViewPoint(newVertex), false, Color.green, InsertVertexTool.this.getPanel(), null);
                }
                catch (Throwable t) {
                    InsertVertexTool.this.getPanel().getContext().warnUser(t.toString());
                }
            }
        });
    }

    private HashMap layerToFeaturesInRangeMap() throws NoninvertibleTransformException {
        HashMap<Layer, Collection> layerToFeaturesInRangeMap = new HashMap<Layer, Collection>();
        for (Layer editableLayer : this.getPanel().getLayerManager().getEditableLayers()) {
            Collection featuresInRange = this.featuresInRange(this.modelClickCoordinate(), editableLayer);
            if (featuresInRange.isEmpty()) continue;
            layerToFeaturesInRangeMap.put(editableLayer, featuresInRange);
        }
        return layerToFeaturesInRangeMap;
    }

    @Override
    public Icon getIcon() {
        return IconLoader.icon("InsertVertex.gif");
    }

    @Override
    public Cursor getCursor() {
        return InsertVertexTool.createCursor(IconLoader.icon("PlusCursor.gif").getImage());
    }

    protected static class SegmentContext {
        private LineSegment segment;
        private Feature feature;
        private Layer layer;

        public SegmentContext(Layer layer, Feature feature, LineSegment segment) {
            this.layer = layer;
            this.feature = feature;
            this.segment = segment;
        }

        public Feature getFeature() {
            return this.feature;
        }

        public Layer getLayer() {
            return this.layer;
        }

        public LineSegment getSegment() {
            return this.segment;
        }
    }
}

