/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui.plugin;

import java.util.ArrayList;
import java.util.Iterator;
import org.locationtech.jts.jump.feature.Feature;
import org.locationtech.jts.jump.feature.FeatureCollection;
import org.locationtech.jts.jump.feature.FeatureUtil;
import org.locationtech.jts.jump.workbench.WorkbenchContext;
import org.locationtech.jts.jump.workbench.model.Layer;
import org.locationtech.jts.jump.workbench.model.UndoableCommand;
import org.locationtech.jts.jump.workbench.plugin.EnableCheckFactory;
import org.locationtech.jts.jump.workbench.plugin.MultiEnableCheck;
import org.locationtech.jts.jump.workbench.plugin.PlugInContext;
import org.locationtech.jts.jump.workbench.ui.EnterWKTDialog;
import org.locationtech.jts.jump.workbench.ui.plugin.WKTPlugIn;

public class AddNewFeaturesPlugIn
extends WKTPlugIn {
    @Override
    protected Layer layer(PlugInContext context) {
        return context.getLayerNamePanel().chooseEditableLayer();
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        return super.execute(context);
    }

    @Override
    protected void apply(FeatureCollection c, PlugInContext context) {
        final ArrayList<Feature> features = new ArrayList<Feature>();
        Iterator i = c.iterator();
        while (i.hasNext()) {
            Feature feature = (Feature)i.next();
            features.add(FeatureUtil.toFeature(feature.getGeometry(), c.getFeatureSchema()));
        }
        this.execute(new UndoableCommand(this.getName()){

            @Override
            public void execute() {
                AddNewFeaturesPlugIn.this.layer.getFeatureCollectionWrapper().addAll(features);
            }

            @Override
            public void unexecute() {
                AddNewFeaturesPlugIn.this.layer.getFeatureCollectionWrapper().removeAll(features);
            }
        }, context);
    }

    @Override
    protected EnterWKTDialog createDialog(PlugInContext context) {
        EnterWKTDialog d = super.createDialog(context);
        d.setTitle("Add Features To " + this.layer);
        d.setDescription("<HTML>Enter Well-Known Text for one or more geometries.</HTML>");
        return d;
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createAtLeastNLayersMustBeEditableCheck(1));
    }
}

