/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui.plugin;

import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.jump.feature.BasicFeature;
import org.locationtech.jts.jump.workbench.model.Layer;
import org.locationtech.jts.jump.workbench.plugin.AbstractPlugIn;
import org.locationtech.jts.jump.workbench.plugin.PlugInContext;
import org.locationtech.jts.jump.workbench.ui.GUIUtil;
import org.locationtech.jts.jump.workbench.ui.TreeLayerNamePanel;
import org.locationtech.jts.jump.workbench.ui.plugin.AddNewLayerPlugIn;
import org.locationtech.jts.util.Assert;

public class AddWMSDemoBoxEasterEggPlugIn
extends AbstractPlugIn {
    private Collection panelsEncountered = new ArrayList();

    @Override
    public void initialize(PlugInContext context) throws Exception {
        context.getWorkbenchFrame().getDesktopPane().addContainerListener(new ContainerAdapter(){

            @Override
            public void componentAdded(ContainerEvent e) {
                if (!(e.getChild() instanceof JInternalFrame)) {
                    return;
                }
                AddWMSDemoBoxEasterEggPlugIn.this.installListener((JInternalFrame)e.getChild());
            }
        });
        for (JInternalFrame internalFrame : Arrays.asList(context.getWorkbenchFrame().getInternalFrames())) {
            this.installListener(internalFrame);
        }
    }

    private void installListener(JInternalFrame internalFrame) {
        final TreeLayerNamePanel panel = (TreeLayerNamePanel)GUIUtil.getDescendantOfClass(TreeLayerNamePanel.class, internalFrame);
        if (panel == null || this.panelsEncountered.contains(panel)) {
            return;
        }
        this.panelsEncountered.add(panel);
        panel.getTree().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e) && e.getClickCount() == 3) {
                    Layer layer = panel.getLayerManager().addLayer("Working", "WMS Demo Box", AddNewLayerPlugIn.createBlankFeatureCollection());
                    BasicFeature feature = new BasicFeature(layer.getFeatureCollectionWrapper().getFeatureSchema());
                    try {
                        feature.setGeometry(new WKTReader().read("LINESTRING (1455960 703340, 1455960 701960, 1457540 701960, 1457540 703340, 1455960 703340)"));
                    }
                    catch (ParseException x) {
                        Assert.shouldNeverReachHere();
                    }
                    layer.getFeatureCollectionWrapper().add(feature);
                }
            }
        });
    }
}

