/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui.plugin;

import java.util.Arrays;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import org.locationtech.jts.jump.workbench.WorkbenchContext;
import org.locationtech.jts.jump.workbench.model.Layer;
import org.locationtech.jts.jump.workbench.plugin.AbstractPlugIn;
import org.locationtech.jts.jump.workbench.plugin.EnableCheck;
import org.locationtech.jts.jump.workbench.plugin.EnableCheckFactory;
import org.locationtech.jts.jump.workbench.plugin.MultiEnableCheck;
import org.locationtech.jts.jump.workbench.plugin.PlugInContext;
import org.locationtech.jts.jump.workbench.ui.cursortool.editing.EditingPlugIn;

public class EditablePlugIn
extends AbstractPlugIn {
    private EditingPlugIn editingPlugIn;

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        boolean makeEditable = !context.getSelectedLayer(0).isEditable();
        for (Layer selectedLayer : Arrays.asList(context.getSelectedLayers())) {
            selectedLayer.setEditable(makeEditable);
        }
        if (makeEditable && !this.editingPlugIn.getToolbox(context.getWorkbenchContext()).isVisible()) {
            this.editingPlugIn.execute(context);
        }
        return true;
    }

    public EnableCheck createEnableCheck(final WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createAtLeastNLayersMustBeSelectedCheck(1)).add(new EnableCheck(){

            @Override
            public String check(JComponent component) {
                ((JCheckBoxMenuItem)component).setSelected(workbenchContext.createPlugInContext().getSelectedLayer(0).isEditable());
                return null;
            }
        });
    }

    public EditablePlugIn(EditingPlugIn editingPlugIn) {
        this.editingPlugIn = editingPlugIn;
    }
}

