/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui.plugin;

import java.util.Iterator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.jump.feature.Feature;
import org.locationtech.jts.jump.workbench.model.Layer;
import org.locationtech.jts.jump.workbench.plugin.AbstractPlugIn;
import org.locationtech.jts.jump.workbench.plugin.PlugInContext;
import org.locationtech.jts.jump.workbench.ui.HTMLFrame;

public class LayerStatisticsPlugIn
extends AbstractPlugIn {
    @Override
    public boolean execute(PlugInContext context) throws Exception {
        Layer[] selectedLayers = context.getSelectedLayers();
        HTMLFrame out = context.getOutputFrame();
        out.createNewDocument();
        out.addHeader(1, "Layer Statistics");
        LayerStatistics totalStats = new LayerStatistics();
        Envelope totalEnv = new Envelope();
        for (int i = 0; i < selectedLayers.length; ++i) {
            Layer layer = selectedLayers[i];
            LayerStatistics ls = this.layerStatistics(layer, totalStats);
            out.addHeader(2, "Layer: " + layer.getName());
            Envelope layerEnv = layer.getFeatureCollectionWrapper().getEnvelope();
            out.addField("Envelope:", layerEnv.toString());
            totalEnv.expandToInclude(layerEnv);
            this.output(ls, out);
        }
        if (selectedLayers.length > 1) {
            out.addHeader(2, "Summary for all Layers");
            out.addField("Envelope:", totalEnv.toString());
            this.output(totalStats, out);
        }
        out.surface();
        return true;
    }

    private LayerStatistics layerStatistics(Layer layer, LayerStatistics totalStats) {
        LayerStatistics ls = new LayerStatistics();
        Iterator i = layer.getFeatureCollectionWrapper().iterator();
        while (i.hasNext()) {
            Feature f = (Feature)i.next();
            Geometry g = f.getGeometry();
            double area = g.getArea();
            double length = g.getLength();
            int comps = 1;
            if (g instanceof GeometryCollection) {
                comps = ((GeometryCollection)g).getNumGeometries();
            }
            Coordinate[] pts = g.getCoordinates();
            int holes = 0;
            if (g instanceof Polygon) {
                holes = ((Polygon)g).getNumInteriorRing();
            }
            ls.addFeature(pts.length, holes, comps, area, length);
            totalStats.addFeature(pts.length, holes, comps, area, length);
        }
        return ls;
    }

    public void output(LayerStatistics ls, HTMLFrame out) {
        out.addField("# Features:", ls.featureCount + "");
        out.append("<table border='1'>");
        out.append("<tr><td bgcolor=#CCCCCC>&nbsp;</td><td  bgcolor=#CCCCCC align='center'> Min </td><td  bgcolor=#CCCCCC align='center'> Max </td><td  bgcolor=#CCCCCC align='center'> Avg </td><td  bgcolor=#CCCCCC align='center'> Total </td></tr>");
        out.append("<tr><td bgcolor=#CCCCCC> Pts </td><td align='right'>" + ls.minCoord + "</td><td align='right'>" + ls.maxCoord + "</td><td align='right'>" + ls.avgCoord() + "</td><td align='right'>" + ls.totalCoord + "</td></tr>");
        out.append("<tr><td bgcolor=#CCCCCC> Holes </td><td align='right'>" + ls.minHoles + "</td><td align='right'>" + ls.maxHoles + "</td><td align='right'>" + ls.avgHoles() + "</td><td align='right'>" + ls.totalHoles + "</td></tr>");
        out.append("<tr><td bgcolor=#CCCCCC> Components </td><td align='right'>" + ls.minComp + "</td><td align='right'>" + ls.maxComp + "</td><td align='right'>" + ls.avgComp() + "</td><td align='right'>" + ls.totalComp + "</td></tr>");
        out.append("<tr><td bgcolor=#CCCCCC> Area </td><td align='right'>" + ls.minArea + "</td><td align='right'>" + ls.maxArea + "</td><td align='right'>" + ls.avgArea() + "</td><td align='right'>" + ls.totalArea + "</td></tr>");
        out.append("<tr><td bgcolor=#CCCCCC> Length </td><td align='right'>" + ls.minLength + "</td><td align='right'>" + ls.maxLength + "</td><td align='right'>" + ls.avgLength() + "</td><td align='right'>" + ls.totalLength + "</td></tr>");
        out.append("</table>");
    }

    public class LayerStatistics {
        boolean isFirst = true;
        int minCoord = 0;
        int maxCoord = 0;
        int totalCoord = 0;
        int minComp = 0;
        int maxComp = 0;
        int totalComp = 0;
        int minHoles = 0;
        int maxHoles = 0;
        int totalHoles = 0;
        double minArea = 0.0;
        double maxArea = 0.0;
        double totalArea = 0.0;
        double minLength = 0.0;
        double maxLength = 0.0;
        double totalLength = 0.0;
        int featureCount = 0;

        public void addFeature(int coordCount, int holeCount, int compCount, double area, double length) {
            ++this.featureCount;
            if (this.isFirst || coordCount < this.minCoord) {
                this.minCoord = coordCount;
            }
            if (this.isFirst || coordCount > this.maxCoord) {
                this.maxCoord = coordCount;
            }
            this.totalCoord += coordCount;
            if (this.isFirst || holeCount < this.minHoles) {
                this.minHoles = holeCount;
            }
            if (this.isFirst || holeCount > this.maxHoles) {
                this.maxHoles = holeCount;
            }
            this.totalHoles += holeCount;
            if (this.isFirst || compCount < this.minComp) {
                this.minComp = compCount;
            }
            if (this.isFirst || compCount > this.maxComp) {
                this.maxComp = compCount;
            }
            this.totalComp += compCount;
            if (this.isFirst || area < this.minArea) {
                this.minArea = area;
            }
            if (this.isFirst || area > this.maxArea) {
                this.maxArea = area;
            }
            this.totalArea += area;
            if (this.isFirst || length < this.minLength) {
                this.minLength = length;
            }
            if (this.isFirst || length > this.maxLength) {
                this.maxLength = length;
            }
            this.totalLength += length;
            this.isFirst = false;
        }

        public double avgCoord() {
            return this.featureCount == 0 ? 0.0 : (double)(this.totalCoord / this.featureCount);
        }

        public double avgHoles() {
            return this.featureCount == 0 ? 0.0 : (double)(this.totalHoles / this.featureCount);
        }

        public double avgComp() {
            return this.featureCount == 0 ? 0.0 : (double)(this.totalComp / this.featureCount);
        }

        public double avgArea() {
            return this.featureCount == 0 ? 0.0 : this.totalArea / (double)this.featureCount;
        }

        public double avgLength() {
            return this.featureCount == 0 ? 0.0 : this.totalLength / (double)this.featureCount;
        }
    }
}

