/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui.plugin;

import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import org.locationtech.jts.jump.util.Blackboard;
import org.locationtech.jts.jump.util.java2xml.Java2XML;
import org.locationtech.jts.jump.util.java2xml.XML2Java;
import org.locationtech.jts.jump.workbench.WorkbenchContext;
import org.locationtech.jts.jump.workbench.plugin.AbstractPlugIn;
import org.locationtech.jts.jump.workbench.plugin.PlugInContext;

public class PersistentBlackboardPlugIn
extends AbstractPlugIn {
    private static final String FILENAME = "workbench-state.xml";
    private static final String BLACKBOARD_KEY = PersistentBlackboardPlugIn.class.getName() + " - BLACKBOARD";

    public static Blackboard get(WorkbenchContext context) {
        return (Blackboard)context.getBlackboard().get(BLACKBOARD_KEY, new Blackboard());
    }

    @Override
    public void initialize(final PlugInContext context) throws Exception {
        this.restoreState(context.getWorkbenchContext());
        context.getWorkbenchFrame().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                PersistentBlackboardPlugIn.this.saveState(context.getWorkbenchContext());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreState(WorkbenchContext workbenchContext) {
        try (FileReader fileReader = new FileReader(FILENAME);
             BufferedReader bufferedReader = new BufferedReader(fileReader);){
            PersistentBlackboardPlugIn.get(workbenchContext).putAll(((Blackboard)new XML2Java().read(bufferedReader, Blackboard.class)).getProperties());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveState(WorkbenchContext workbenchContext) {
        try (FileWriter fileWriter = new FileWriter(FILENAME, false);
             BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);){
            new Java2XML().write((Object)PersistentBlackboardPlugIn.get(workbenchContext), "workbench-state", bufferedWriter);
            bufferedWriter.flush();
            fileWriter.flush();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }
}

