/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui.plugin;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JInternalFrame;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import org.locationtech.jts.jump.workbench.WorkbenchContext;
import org.locationtech.jts.jump.workbench.model.CategoryEvent;
import org.locationtech.jts.jump.workbench.model.FeatureEvent;
import org.locationtech.jts.jump.workbench.model.Layer;
import org.locationtech.jts.jump.workbench.model.LayerEvent;
import org.locationtech.jts.jump.workbench.model.LayerListener;
import org.locationtech.jts.jump.workbench.model.LayerManager;
import org.locationtech.jts.jump.workbench.model.LayerManagerProxy;
import org.locationtech.jts.jump.workbench.plugin.AbstractPlugIn;
import org.locationtech.jts.jump.workbench.plugin.EnableCheckFactory;
import org.locationtech.jts.jump.workbench.plugin.MultiEnableCheck;
import org.locationtech.jts.jump.workbench.plugin.PlugInContext;
import org.locationtech.jts.jump.workbench.ui.CloneableInternalFrame;
import org.locationtech.jts.jump.workbench.ui.LayerNamePanel;
import org.locationtech.jts.jump.workbench.ui.LayerNamePanelProxy;
import org.locationtech.jts.jump.workbench.ui.LayerViewPanel;
import org.locationtech.jts.jump.workbench.ui.LayerViewPanelProxy;
import org.locationtech.jts.jump.workbench.ui.OneLayerAttributeTab;
import org.locationtech.jts.jump.workbench.ui.SelectionManager;
import org.locationtech.jts.jump.workbench.ui.SelectionManagerProxy;
import org.locationtech.jts.jump.workbench.ui.TaskFrame;
import org.locationtech.jts.jump.workbench.ui.TaskFrameProxy;
import org.locationtech.jts.jump.workbench.ui.images.IconLoader;
import org.locationtech.jts.util.Assert;

public class ViewAttributesPlugIn
extends AbstractPlugIn {
    @Override
    public String getName() {
        return "View / Edit Attributes";
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        ViewAttributesFrame frame = new ViewAttributesFrame(context.getSelectedLayer(0), context);
        context.getWorkbenchFrame().addInternalFrame(frame);
        return true;
    }

    public MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createTaskWindowMustBeActiveCheck()).add(checkFactory.createExactlyNLayersMustBeSelectedCheck(1));
    }

    public ImageIcon getIcon() {
        return IconLoader.icon("Row.gif");
    }

    public static class ViewAttributesFrame
    extends JInternalFrame
    implements LayerManagerProxy,
    SelectionManagerProxy,
    LayerNamePanelProxy,
    TaskFrameProxy,
    LayerViewPanelProxy {
        private LayerManager layerManager;
        private OneLayerAttributeTab attributeTab;

        public ViewAttributesFrame(Layer layer, PlugInContext context) {
            this.layerManager = context.getLayerManager();
            this.addInternalFrameListener(new InternalFrameAdapter(){

                @Override
                public void internalFrameClosed(InternalFrameEvent e) {
                    attributeTab.getModel().dispose();
                }
            });
            this.setResizable(true);
            this.setClosable(true);
            this.setMaximizable(true);
            this.setIconifiable(true);
            this.getContentPane().setLayout(new BorderLayout());
            this.attributeTab = new OneLayerAttributeTab(context.getWorkbenchContext(), ((TaskFrameProxy)((Object)context.getActiveInternalFrame())).getTaskFrame(), this).setLayer(layer);
            this.addInternalFrameListener(new InternalFrameAdapter(){

                @Override
                public void internalFrameOpened(InternalFrameEvent e) {
                    attributeTab.getToolBar().updateEnabledState();
                }
            });
            this.getContentPane().add((Component)this.attributeTab, "Center");
            this.setSize(500, 300);
            this.updateTitle(this.attributeTab.getLayer());
            context.getLayerManager().addLayerListener(new LayerListener(){

                @Override
                public void layerChanged(LayerEvent e) {
                    if (attributeTab.getLayer() != null) {
                        this.updateTitle(attributeTab.getLayer());
                    }
                }

                @Override
                public void categoryChanged(CategoryEvent e) {
                }

                @Override
                public void featuresChanged(FeatureEvent e) {
                }
            });
            Assert.isTrue((!(this instanceof CloneableInternalFrame) ? 1 : 0) != 0, (String)"There can be no other views on the InfoModel");
        }

        @Override
        public LayerViewPanel getLayerViewPanel() {
            return this.getTaskFrame().getLayerViewPanel();
        }

        @Override
        public LayerManager getLayerManager() {
            return this.layerManager;
        }

        private void updateTitle(Layer layer) {
            this.setTitle((layer.isEditable() ? "Edit" : "View") + " Attributes: " + layer.getName());
        }

        @Override
        public TaskFrame getTaskFrame() {
            return this.attributeTab.getTaskFrame();
        }

        @Override
        public SelectionManager getSelectionManager() {
            return this.attributeTab.getPanel().getSelectionManager();
        }

        @Override
        public LayerNamePanel getLayerNamePanel() {
            return this.attributeTab;
        }
    }
}

