/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui.plugin.analysis;

import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JComboBox;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.jump.feature.Feature;
import org.locationtech.jts.jump.feature.FeatureCollection;
import org.locationtech.jts.jump.feature.FeatureCollectionWrapper;
import org.locationtech.jts.jump.feature.FeatureDatasetFactory;
import org.locationtech.jts.jump.task.TaskMonitor;
import org.locationtech.jts.jump.workbench.plugin.AbstractPlugIn;
import org.locationtech.jts.jump.workbench.plugin.PlugInContext;
import org.locationtech.jts.jump.workbench.plugin.ThreadedPlugIn;
import org.locationtech.jts.jump.workbench.ui.GUIUtil;
import org.locationtech.jts.jump.workbench.ui.MultiInputDialog;

public class UnionPlugIn
extends AbstractPlugIn
implements ThreadedPlugIn {
    private static final String LAYER = "Layer";
    private MultiInputDialog dialog;

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.initDialog(context);
        this.dialog.setVisible(true);
        return this.dialog.wasOKPressed();
    }

    private void initDialog(PlugInContext context) {
        this.dialog = new MultiInputDialog(context.getWorkbenchFrame(), "Union", true);
        this.dialog.setSideBarDescription("Creates a new layer containing the union of all the features in the input layer");
        String fieldName = LAYER;
        JComboBox addLayerComboBox = this.dialog.addLayerComboBox(fieldName, context.getCandidateLayer(0), null, context.getLayerManager());
        GUIUtil.centreOnWindow(this.dialog);
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        FeatureCollectionWrapper a = this.dialog.getLayer(LAYER).getFeatureCollectionWrapper();
        FeatureCollection union = this.union(monitor, a);
        context.addLayer("Working", "Union", union);
    }

    private FeatureCollection union(TaskMonitor monitor, FeatureCollection fc) {
        monitor.allowCancellationRequests();
        monitor.report("Computing Union...");
        ArrayList<Geometry> unionGeometryList = new ArrayList<Geometry>();
        Geometry currUnion = null;
        int size = fc.size();
        int count = 1;
        Iterator i = fc.iterator();
        while (i.hasNext()) {
            Feature f = (Feature)i.next();
            Geometry geom = f.getGeometry();
            currUnion = currUnion == null ? geom : currUnion.union(geom);
            monitor.report(count++, size, "features");
        }
        unionGeometryList.add(currUnion);
        return FeatureDatasetFactory.createFromGeometry(unionGeometryList);
    }
}

