/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui.plugin.clipboard;

import java.util.Iterator;
import org.locationtech.jts.jump.feature.Feature;
import org.locationtech.jts.jump.feature.FeatureCollection;
import org.locationtech.jts.jump.feature.FeatureDataset;
import org.locationtech.jts.jump.workbench.model.Layer;
import org.locationtech.jts.jump.workbench.model.LayerManager;
import org.locationtech.jts.jump.workbench.model.Layerable;
import org.locationtech.jts.jump.workbench.model.WMSLayer;
import org.locationtech.jts.jump.workbench.plugin.AbstractPlugIn;
import org.locationtech.jts.util.Assert;

public abstract class LayerableClipboardPlugIn
extends AbstractPlugIn {
    protected Layerable cloneLayerable(Layerable layerable) {
        if (layerable instanceof Layer) {
            return this.cloneLayer((Layer)layerable);
        }
        if (layerable instanceof WMSLayer) {
            try {
                return (Layerable)((WMSLayer)layerable).clone();
            }
            catch (CloneNotSupportedException e) {
                Assert.shouldNeverReachHere();
            }
        }
        Assert.shouldNeverReachHere();
        return null;
    }

    protected Layer cloneLayer(Layer layer) {
        LayerManager dummyLayerManager = new LayerManager();
        dummyLayerManager.setFiringEvents(false);
        Layer clone = new Layer();
        clone.setLayerManager(dummyLayerManager);
        clone.setStyles(layer.cloneStyles());
        clone.setName(layer.getName());
        clone.setFeatureCollection(this.cloneFeatureCollection(layer.getFeatureCollectionWrapper()));
        return clone;
    }

    private FeatureCollection cloneFeatureCollection(FeatureCollection featureCollection) {
        FeatureDataset d = new FeatureDataset(featureCollection.getFeatureSchema());
        Iterator i = featureCollection.iterator();
        while (i.hasNext()) {
            Feature f = (Feature)i.next();
            d.add((Feature)f.clone());
        }
        return d;
    }
}

