/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui.plugin.generate;

import java.awt.Color;
import java.awt.Font;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.jump.feature.AttributeType;
import org.locationtech.jts.jump.feature.BasicFeature;
import org.locationtech.jts.jump.feature.FeatureCollection;
import org.locationtech.jts.jump.feature.FeatureDataset;
import org.locationtech.jts.jump.feature.FeatureSchema;
import org.locationtech.jts.jump.task.DummyTaskMonitor;
import org.locationtech.jts.jump.util.CollectionUtil;
import org.locationtech.jts.jump.warp.Triangle;
import org.locationtech.jts.jump.warp.Triangulator;
import org.locationtech.jts.jump.workbench.WorkbenchContext;
import org.locationtech.jts.jump.workbench.model.Layer;
import org.locationtech.jts.jump.workbench.model.LayerManagerProxy;
import org.locationtech.jts.jump.workbench.model.UndoableCommand;
import org.locationtech.jts.jump.workbench.plugin.AbstractPlugIn;
import org.locationtech.jts.jump.workbench.plugin.EnableCheck;
import org.locationtech.jts.jump.workbench.plugin.EnableCheckFactory;
import org.locationtech.jts.jump.workbench.plugin.MultiEnableCheck;
import org.locationtech.jts.jump.workbench.plugin.PlugInContext;
import org.locationtech.jts.jump.workbench.ui.images.IconLoader;
import org.locationtech.jts.jump.workbench.ui.warp.WarpingPanel;
import org.locationtech.jts.jump.workbench.ui.warp.WarpingVectorLayerFinder;

public class ShowTriangulationPlugIn
extends AbstractPlugIn {
    private static final Color GOLD = new Color(255, 192, 0, 150);
    private Triangulator triangulator = new Triangulator();
    private WarpingPanel warpingPanel;
    public static final String SOURCE_LAYER_NAME = "Initial Triangulation";
    public static final String DESTINATION_LAYER_NAME = "Final Triangulation";
    private static final String WARP_ID_NAME = "WARP_ID";
    private GeometryFactory factory = new GeometryFactory();

    public ShowTriangulationPlugIn(WarpingPanel warpingPanel) {
        this.warpingPanel = warpingPanel;
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
    }

    public EnableCheck createEnableCheck(WorkbenchContext context) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(context);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck());
    }

    private Layer sourceLayer(LayerManagerProxy layerManagerProxy) {
        return layerManagerProxy.getLayerManager().getLayer(SOURCE_LAYER_NAME);
    }

    private Layer destinationLayer(LayerManagerProxy layerManagerProxy) {
        return layerManagerProxy.getLayerManager().getLayer(DESTINATION_LAYER_NAME);
    }

    private WarpingVectorLayerFinder warpingVectorLayerFinder(LayerManagerProxy proxy) {
        return new WarpingVectorLayerFinder(proxy);
    }

    private Envelope envelopeOfTails(Collection vectors) {
        Envelope envelope = new Envelope();
        for (LineString vector : vectors) {
            envelope.expandToInclude(vector.getCoordinateN(0));
        }
        return envelope;
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        context.getLayerManager().getUndoableEditReceiver().reportNothingToUndoYet();
        this.execute(this.createCommand(context.getWorkbenchContext(), true), context);
        return true;
    }

    private UndoableCommand createCommand(final WorkbenchContext context, final boolean createLayersIfNonExistent) {
        Envelope datasetEnvelope = new Envelope();
        if (this.warpingPanel.currentSourceLayer() != null) {
            datasetEnvelope = this.warpingPanel.currentSourceLayer().getFeatureCollectionWrapper().getEnvelope();
        }
        if (datasetEnvelope.isNull()) {
            datasetEnvelope = this.envelopeOfTails(this.warpingVectorLayerFinder(context).getVectors());
        }
        if (datasetEnvelope.isNull()) {
            return UndoableCommand.DUMMY;
        }
        if (datasetEnvelope.getWidth() == 0.0) {
            datasetEnvelope.expandToInclude(new Coordinate(datasetEnvelope.getMinX() + 1.0, datasetEnvelope.getMinY()));
            datasetEnvelope.expandToInclude(new Coordinate(datasetEnvelope.getMinX() - 1.0, datasetEnvelope.getMinY()));
        }
        if (datasetEnvelope.getHeight() == 0.0) {
            datasetEnvelope.expandToInclude(new Coordinate(datasetEnvelope.getMinX(), datasetEnvelope.getMinY() + 1.0));
            datasetEnvelope.expandToInclude(new Coordinate(datasetEnvelope.getMinX(), datasetEnvelope.getMinY() - 1.0));
        }
        Map triangleMap = this.triangulator.triangleMap(datasetEnvelope, this.warpingVectorLayerFinder(context).getVectors(), new DummyTaskMonitor());
        List[] sourceAndDestinationTriangles = CollectionUtil.keysAndCorrespondingValues(triangleMap);
        final FeatureCollection sourceFeatureCollection = this.toFeatureCollection(sourceAndDestinationTriangles[0]);
        final FeatureCollection destinationFeatureCollection = this.toFeatureCollection(sourceAndDestinationTriangles[1]);
        return ShowTriangulationPlugIn.addUndo(new UndoableCommand(this.getName()){

            @Override
            public void execute() {
                if (ShowTriangulationPlugIn.this.sourceLayer(context) != null) {
                    ShowTriangulationPlugIn.this.sourceLayer(context).setFeatureCollection(sourceFeatureCollection);
                    ShowTriangulationPlugIn.this.sourceLayer(context).setVisible(true);
                }
                if (ShowTriangulationPlugIn.this.sourceLayer(context) == null && createLayersIfNonExistent) {
                    Layer sourceLayer = context.getLayerManager().addLayer("Working", ShowTriangulationPlugIn.SOURCE_LAYER_NAME, sourceFeatureCollection);
                    ShowTriangulationPlugIn.this.init(sourceLayer, Color.gray, 150, 1);
                }
                if (ShowTriangulationPlugIn.this.destinationLayer(context) != null) {
                    ShowTriangulationPlugIn.this.destinationLayer(context).setFeatureCollection(destinationFeatureCollection);
                    ShowTriangulationPlugIn.this.destinationLayer(context).setVisible(true);
                }
                if (ShowTriangulationPlugIn.this.destinationLayer(context) == null && createLayersIfNonExistent) {
                    Layer destinationLayer = context.getLayerManager().addLayer("Working", ShowTriangulationPlugIn.DESTINATION_LAYER_NAME, destinationFeatureCollection);
                    ShowTriangulationPlugIn.this.init(destinationLayer, GOLD, 255, 1);
                }
            }

            @Override
            public void unexecute() {
            }
        }, context);
    }

    public UndoableCommand addLayerGeneration(final UndoableCommand wrappeeCommand, final WorkbenchContext context, final boolean createLayersIfNonExistent) {
        return new UndoableCommand(wrappeeCommand.getName()){
            private UndoableCommand layerGenerationCommand;
            {
                super(name);
                this.layerGenerationCommand = null;
            }

            private UndoableCommand layerGenerationCommand() {
                if (this.layerGenerationCommand == null) {
                    this.layerGenerationCommand = ShowTriangulationPlugIn.this.createCommand(context, createLayersIfNonExistent);
                }
                return this.layerGenerationCommand;
            }

            @Override
            public void execute() {
                wrappeeCommand.execute();
                this.layerGenerationCommand().execute();
            }

            @Override
            public void unexecute() {
                this.layerGenerationCommand().unexecute();
                wrappeeCommand.unexecute();
            }
        };
    }

    public static UndoableCommand addUndo(UndoableCommand wrappeeCommand, LayerManagerProxy proxy) {
        return Layer.addUndo(DESTINATION_LAYER_NAME, proxy, Layer.addUndo(SOURCE_LAYER_NAME, proxy, wrappeeCommand));
    }

    private FeatureCollection toFeatureCollection(Collection triangles) {
        FeatureSchema featureSchema = new FeatureSchema();
        featureSchema.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
        featureSchema.addAttribute(WARP_ID_NAME, AttributeType.INTEGER);
        FeatureDataset featureCollection = new FeatureDataset(featureSchema);
        int j = 0;
        for (Triangle t : triangles) {
            BasicFeature feature = new BasicFeature(featureSchema);
            feature.setGeometry((Geometry)this.factory.createPolygon(t.toLinearRing(), null));
            feature.setAttribute(WARP_ID_NAME, (Object)new Integer(++j));
            featureCollection.add(feature);
        }
        return featureCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Layer layer, Color color, int alpha, int lineWidth) {
        boolean firingEvents = layer.getLayerManager().isFiringEvents();
        layer.getLayerManager().setFiringEvents(false);
        try {
            layer.getBasicStyle().setLineColor(color);
            layer.getBasicStyle().setFillColor(color);
            layer.getBasicStyle().setAlpha(alpha);
            layer.getBasicStyle().setLineWidth(lineWidth);
            layer.getBasicStyle().setRenderingFill(false);
            layer.getVertexStyle().setEnabled(true);
            layer.getVertexStyle().setSize(4);
            layer.getLabelStyle().setEnabled(true);
            layer.getLabelStyle().setColor(color);
            layer.getLabelStyle().setFont(new Font("Dialog", 0, 12));
            layer.getLabelStyle().setAttribute(WARP_ID_NAME);
            layer.getLabelStyle().setHeight(12.0);
            layer.getLabelStyle().setScaling(false);
            layer.getLabelStyle().setHidingOverlappingLabels(false);
        }
        finally {
            layer.getLayerManager().setFiringEvents(firingEvents);
        }
        layer.fireAppearanceChanged();
    }

    public Icon getIcon() {
        return IconLoader.icon("Triangle.gif");
    }
}

