/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui.plugin.scalebar;

import java.util.Collection;
import java.util.Collections;
import org.locationtech.jts.jump.util.MathUtil;
import org.locationtech.jts.jump.workbench.ui.plugin.scalebar.RoundQuantity;
import org.locationtech.jts.jump.workbench.ui.plugin.scalebar.Unit;
import org.locationtech.jts.util.Assert;

public class IncrementChooser {
    public RoundQuantity chooseGoodIncrement(Collection units, double idealIncrement) {
        return this.goodIncrement(this.goodUnit(units, idealIncrement), idealIncrement);
    }

    private Unit goodUnit(Collection units, double idealIncrement) {
        Unit goodUnit = (Unit)Collections.min(units);
        for (Unit candidateUnit : units) {
            if (candidateUnit.getModelValue() > idealIncrement || !(this.distance(candidateUnit.getModelValue(), idealIncrement) < this.distance(goodUnit.getModelValue(), idealIncrement))) continue;
            goodUnit = candidateUnit;
        }
        return goodUnit;
    }

    private double distance(double a, double b) {
        return Math.abs(MathUtil.orderOfMagnitude(a) - MathUtil.orderOfMagnitude(b));
    }

    private RoundQuantity goodIncrement(Unit unit, double idealIncrement) {
        RoundQuantity mantissa1Candidate = new RoundQuantity(1, (int)Math.floor(MathUtil.orderOfMagnitude(idealIncrement) - MathUtil.orderOfMagnitude(unit.getModelValue())), unit);
        Assert.isTrue((mantissa1Candidate.getModelValue() <= idealIncrement ? 1 : 0) != 0, (String)("unit=" + unit.getModelValue() + ", ideal increment=" + idealIncrement));
        RoundQuantity mantissa2Candidate = new RoundQuantity(2, mantissa1Candidate.getExponent(), unit);
        RoundQuantity mantissa5Candidate = new RoundQuantity(5, mantissa1Candidate.getExponent(), unit);
        if (mantissa5Candidate.getModelValue() <= idealIncrement) {
            return mantissa5Candidate;
        }
        if (mantissa2Candidate.getModelValue() <= idealIncrement) {
            return mantissa2Candidate;
        }
        return mantissa1Candidate;
    }
}

