/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui.plugin.skin;

import java.util.ArrayList;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.locationtech.jts.jump.workbench.plugin.AbstractPlugIn;
import org.locationtech.jts.jump.workbench.plugin.PlugInContext;
import org.locationtech.jts.jump.workbench.ui.OptionsDialog;
import org.locationtech.jts.jump.workbench.ui.plugin.skin.LookAndFeelProxy;
import org.locationtech.jts.jump.workbench.ui.plugin.skin.SkinOptionsPanel;
import org.locationtech.jts.util.Assert;

public class InstallSkinsPlugIn
extends AbstractPlugIn {
    private LookAndFeelProxy createProxy(final String name, final String lookAndFeelClassName) {
        return new LookAndFeelProxy(){

            @Override
            public LookAndFeel getLookAndFeel() {
                try {
                    return (LookAndFeel)Class.forName(lookAndFeelClassName).newInstance();
                }
                catch (InstantiationException e) {
                    Assert.shouldNeverReachHere((String)e.toString());
                }
                catch (IllegalAccessException e) {
                    Assert.shouldNeverReachHere((String)e.toString());
                }
                catch (ClassNotFoundException e) {
                    Assert.shouldNeverReachHere((String)e.toString());
                }
                return null;
            }

            public String toString() {
                return name;
            }
        };
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        ArrayList<LookAndFeelProxy> skins = new ArrayList<LookAndFeelProxy>();
        skins.add(this.createProxy("Default", UIManager.getSystemLookAndFeelClassName()));
        skins.add(this.createProxy("Metal", UIManager.getCrossPlatformLookAndFeelClassName()));
        skins.add(this.createProxy("Windows", "com.sun.java.swing.plaf.windows.WindowsLookAndFeel"));
        skins.add(this.createProxy("Motif", "com.sun.java.swing.plaf.motif.MotifLookAndFeel"));
        context.getWorkbenchContext().getWorkbench().getBlackboard().put(SkinOptionsPanel.SKINS_KEY, skins);
        OptionsDialog.instance(context.getWorkbenchContext().getWorkbench()).addTab("Skins", new SkinOptionsPanel(context.getWorkbenchContext().getWorkbench().getBlackboard(), context.getWorkbenchFrame()));
    }
}

