/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui.plugin.test;

import java.util.ArrayList;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.jump.feature.AttributeType;
import org.locationtech.jts.jump.feature.BasicFeature;
import org.locationtech.jts.jump.feature.Feature;
import org.locationtech.jts.jump.feature.FeatureCollection;
import org.locationtech.jts.jump.feature.FeatureDataset;
import org.locationtech.jts.jump.feature.FeatureSchema;
import org.locationtech.jts.jump.geom.CoordUtil;
import org.locationtech.jts.jump.workbench.model.Layer;
import org.locationtech.jts.jump.workbench.plugin.AbstractPlugIn;
import org.locationtech.jts.jump.workbench.plugin.PlugIn;
import org.locationtech.jts.jump.workbench.plugin.PlugInContext;
import org.locationtech.jts.jump.workbench.ui.renderer.style.ArrowLineStringEndpointStyle;

public class RandomArrowsPlugIn
extends AbstractPlugIn {
    private static final int FEATURE_COUNT = 20;
    private static final double LAYER_SIDE_LENGTH = 100.0;
    private static final int MAX_SEGMENT_COUNT = 3;
    private static final double MAX_SEGMENT_LENGTH = 20.0;
    private GeometryFactory geometryFactory = new GeometryFactory();

    @Override
    public void initialize(PlugInContext context) throws Exception {
        context.getFeatureInstaller().addLayerViewMenuItem((PlugIn)this, new String[]{"Tools", "Generate"}, this.getName());
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        FeatureSchema schema = new FeatureSchema();
        schema.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
        FeatureDataset dataset = new FeatureDataset(schema);
        for (int i = 0; i < 20; ++i) {
            dataset.add(this.createFeature(schema));
        }
        this.addLayer(dataset, context);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLayer(FeatureCollection featureCollection, PlugInContext context) {
        Layer layer = new Layer("Random Arrows", context.getLayerManager().generateLayerFillColor(), featureCollection, context.getLayerManager());
        boolean firingEvents = context.getLayerManager().isFiringEvents();
        context.getLayerManager().setFiringEvents(false);
        try {
            layer.addStyle(new ArrowLineStringEndpointStyle.NarrowSolidEnd());
        }
        finally {
            context.getLayerManager().setFiringEvents(firingEvents);
        }
        context.getLayerManager().addLayer("Working", layer);
    }

    private Feature createFeature(FeatureSchema schema) {
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        coordinates.add(CoordUtil.add(new Coordinate(50.0, 50.0), this.randomCoordinate(50.0)));
        int walkMax = (int)Math.ceil(Math.random() * 20.0);
        int segmentCount = (int)Math.ceil(Math.random() * 3.0);
        for (int i = 0; i < segmentCount; ++i) {
            Coordinate prevCoordinate = (Coordinate)coordinates.get(coordinates.size() - 1);
            coordinates.add(CoordUtil.add(prevCoordinate, this.randomCoordinate(walkMax)));
        }
        LineString lineString = this.geometryFactory.createLineString(coordinates.toArray(new Coordinate[0]));
        BasicFeature feature = new BasicFeature(schema);
        feature.setGeometry((Geometry)lineString);
        return feature;
    }

    private Coordinate randomCoordinate(double walkMax) {
        return CoordUtil.add(new Coordinate(-walkMax / 2.0, -walkMax / 2.0), new Coordinate(Math.random() * walkMax, Math.random() * walkMax));
    }
}

