/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui.renderer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Icon;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.jump.feature.Feature;
import org.locationtech.jts.jump.util.CollectionMap;
import org.locationtech.jts.jump.workbench.model.Layer;
import org.locationtech.jts.jump.workbench.ui.GUIUtil;
import org.locationtech.jts.jump.workbench.ui.LayerViewPanel;
import org.locationtech.jts.jump.workbench.ui.Viewport;
import org.locationtech.jts.jump.workbench.ui.renderer.FeatureCollectionRenderer;
import org.locationtech.jts.jump.workbench.ui.renderer.style.Style;
import org.locationtech.jts.jump.workbench.ui.renderer.style.StyleUtil;
import org.locationtech.jts.util.Assert;

public abstract class AbstractSelectionRenderer
extends FeatureCollectionRenderer
implements Style {
    public static final int HANDLE_WIDTH = 5;
    private boolean enabled = true;
    private Stroke handleStroke = new BasicStroke(1.0f);
    private Color handleFillColor;
    private Color handleLineColor = Color.black;
    private Stroke lineStroke = new BasicStroke(2.0f);
    private Color lineColor;
    private Stroke fillStroke = new BasicStroke(1.0f);
    private Color fillColor;
    private boolean filling = true;
    protected LayerViewPanel panel;
    private CollectionMap featureToSelectedItemsMap;
    private boolean paintingHandles;

    public AbstractSelectionRenderer(Object contentID, LayerViewPanel panel, Color color, boolean paintingHandles, boolean filling) {
        super(contentID, panel);
        this.panel = panel;
        this.handleFillColor = color;
        this.lineColor = color;
        this.fillColor = GUIUtil.alphaColor(Color.white, 75);
        this.paintingHandles = paintingHandles;
        this.filling = filling;
    }

    public String getName() {
        throw new UnsupportedOperationException();
    }

    public Icon getIcon() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public Object clone() {
        Assert.shouldNeverReachHere();
        return null;
    }

    @Override
    public void initialize(Layer layer) {
    }

    @Override
    public void paint(Feature f, Graphics2D g, Viewport viewport) throws NoninvertibleTransformException {
        for (Geometry geometry : this.featureToSelectedItemsMap.getItems(f)) {
            this.paint(geometry, g, viewport);
        }
    }

    public void paint(Geometry geometry, Graphics2D g, Viewport viewport) throws NoninvertibleTransformException {
        Coordinate[] coordinates = geometry.getCoordinates();
        StyleUtil.paint(geometry, g, viewport, this.filling, this.fillStroke, this.fillColor, true, this.lineStroke, this.lineColor);
        if (this.paintingHandles) {
            AbstractSelectionRenderer.paintHandles(g, coordinates, this.handleStroke, this.handleFillColor, this.handleLineColor, this.panel.getViewport());
        }
    }

    @Override
    protected Collection styles() {
        return Collections.singleton(this);
    }

    @Override
    protected Map layerToFeaturesMap() {
        this.featureToSelectedItemsMap = new CollectionMap();
        HashMap layerToFeaturesMap = new HashMap();
        Iterator i = this.panel.getLayerManager().iterator();
        while (i.hasNext()) {
            Layer layer = (Layer)i.next();
            CollectionMap featureToSelectedItemsMapForLayer = this.featureToSelectedItemsMap(layer);
            this.featureToSelectedItemsMap.putAll((Map)featureToSelectedItemsMapForLayer);
            layerToFeaturesMap.put(layer, featureToSelectedItemsMapForLayer.keySet());
        }
        return layerToFeaturesMap;
    }

    protected abstract CollectionMap featureToSelectedItemsMap(Layer var1);

    private static Shape handle(Point2D point) {
        Rectangle2D.Double handle = new Rectangle2D.Double(0.0, 0.0, 5.0, 5.0);
        handle.x = point.getX() - 2.0;
        handle.y = point.getY() - 2.0;
        return handle;
    }

    public static void paintHandles(Graphics2D g, Coordinate[] coordinates, Stroke stroke, Color fillColor, Color lineColor, Viewport viewport) throws NoninvertibleTransformException {
        int i;
        g.setStroke(stroke);
        g.setColor(fillColor);
        for (i = 0; i < coordinates.length; ++i) {
            if (!viewport.getEnvelopeInModelCoordinates().contains(coordinates[i])) continue;
            g.fill(AbstractSelectionRenderer.handle(viewport.toViewPoint(new Point2D.Double(coordinates[i].x, coordinates[i].y))));
        }
        g.setColor(lineColor);
        for (i = 0; i < coordinates.length; ++i) {
            if (!viewport.getEnvelopeInModelCoordinates().contains(coordinates[i])) continue;
            g.draw(AbstractSelectionRenderer.handle(viewport.toViewPoint(new Point2D.Double(coordinates[i].x, coordinates[i].y))));
        }
    }
}

