/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui.renderer;

import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.locationtech.jts.jump.feature.Feature;
import org.locationtech.jts.jump.workbench.model.Layer;
import org.locationtech.jts.jump.workbench.ui.LayerViewPanel;
import org.locationtech.jts.jump.workbench.ui.renderer.SimpleRenderer;
import org.locationtech.jts.jump.workbench.ui.renderer.style.Style;

public class SimpleFeatureCollectionRenderer
extends SimpleRenderer {
    private Collection styles = new ArrayList();
    private Map layerToFeaturesMap = new HashMap();

    public SimpleFeatureCollectionRenderer(Object contentID, LayerViewPanel panel) {
        super(contentID, panel);
    }

    private void paint(Graphics2D g, Collection features, Layer layer, Style style) throws Exception {
        if (!layer.isVisible()) {
            return;
        }
        if (!style.isEnabled()) {
            return;
        }
        style.initialize(layer);
        for (Feature feature : new ArrayList(features)) {
            if (feature.getGeometry().isEmpty()) continue;
            style.paint(feature, g, this.panel.getViewport());
        }
    }

    @Override
    protected void paint(Graphics2D g) throws Exception {
        for (Style style : this.styles) {
            for (Layer layer : this.layerToFeaturesMap.keySet()) {
                Collection features = (Collection)this.layerToFeaturesMap.get(layer);
                this.paint(g, features, layer, style);
            }
        }
    }

    protected void setLayerToFeaturesMap(Map layerToFeaturesMap) {
        this.layerToFeaturesMap = layerToFeaturesMap;
    }

    protected void setStyles(Collection styles) {
        this.styles = styles;
    }
}

