/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui.renderer.style;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.locationtech.jts.jump.feature.Feature;
import org.locationtech.jts.jump.util.Range;
import org.locationtech.jts.jump.workbench.WorkbenchContext;
import org.locationtech.jts.jump.workbench.model.Layer;
import org.locationtech.jts.jump.workbench.model.LayerManager;
import org.locationtech.jts.jump.workbench.plugin.AbstractPlugIn;
import org.locationtech.jts.jump.workbench.plugin.EnableCheck;
import org.locationtech.jts.jump.workbench.plugin.MultiEnableCheck;
import org.locationtech.jts.jump.workbench.plugin.PlugInContext;
import org.locationtech.jts.jump.workbench.ui.ColorPanel;
import org.locationtech.jts.jump.workbench.ui.EnableableToolBar;
import org.locationtech.jts.jump.workbench.ui.GUIUtil;
import org.locationtech.jts.jump.workbench.ui.OKCancelPanel;
import org.locationtech.jts.jump.workbench.ui.images.IconLoader;
import org.locationtech.jts.jump.workbench.ui.renderer.style.BasicStyle;
import org.locationtech.jts.jump.workbench.ui.renderer.style.BasicStyleListCellRenderer;
import org.locationtech.jts.jump.workbench.ui.renderer.style.ColorScheme;
import org.locationtech.jts.jump.workbench.ui.renderer.style.ColorSchemeListCellRenderer;
import org.locationtech.jts.jump.workbench.ui.renderer.style.ColorThemingStyle;
import org.locationtech.jts.jump.workbench.ui.renderer.style.ColorThemingTableModel;
import org.locationtech.jts.jump.workbench.ui.renderer.style.DiscreteColorThemingState;
import org.locationtech.jts.jump.workbench.ui.renderer.style.RangeColorThemingState;
import org.locationtech.jts.jump.workbench.ui.style.BasicStylePanel;
import org.locationtech.jts.jump.workbench.ui.style.StylePanel;

public class ColorThemingStylePanel
extends JPanel
implements StylePanel {
    private static final String CUSTOM_ENTRY = "Custom...";
    public static final String TITLE = "Colour Theming";
    public static final String COLOR_SCHEME_KEY = ColorThemingStylePanel.class.getName() + " - COLOR SCHEME";
    private WorkbenchContext workbenchContext;
    private Layer layer;
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JPanel jPanel1 = new JPanel();
    private JScrollPane scrollPane = new JScrollPane();
    private DefaultTableCellRenderer allOtherValuesRenderer = new DefaultTableCellRenderer();
    private JTable table = new JTable(){

        @Override
        public TableCellRenderer getCellRenderer(int row, int column) {
            TableCellRenderer renderer = this.getCellRendererProper(row, column);
            if (renderer instanceof JComponent) {
                ColorThemingStylePanel.this.updateBackground((JComponent)((Object)renderer));
            }
            return renderer;
        }

        private TableCellRenderer getCellRendererProper(int row, int column) {
            if (row == 0 && column == ColorThemingStylePanel.this.attributeColumn()) {
                return ColorThemingStylePanel.this.allOtherValuesRenderer;
            }
            TableCellRenderer renderer = super.getCellRenderer(row, column);
            if (renderer instanceof JLabel) {
                ((JLabel)((Object)renderer)).setHorizontalAlignment(2);
            }
            return renderer;
        }
    };
    private JPanel jPanel3 = new JPanel();
    private GridBagLayout gridBagLayout2 = new GridBagLayout();
    private GridBagLayout gridBagLayout4 = new GridBagLayout();
    private JComboBox attributeNameComboBox = new JComboBox();
    private JLabel attributeLabel = new JLabel();
    private JLabel statusLabel = new JLabel(){

        @Override
        public void setText(String text) {
            super.setText(text);
            this.setToolTipText(text);
        }
    };
    private EnableableToolBar toolBar = new EnableableToolBar();
    private JPanel jPanel4 = new JPanel();
    private GridBagLayout gridBagLayout5 = new GridBagLayout();
    private JComboBox colorSchemeComboBox = new JComboBox();
    private JLabel colorSchemeLabel = new JLabel();
    private boolean updatingComponents = false;
    private boolean initializing = true;
    private BasicStyleListCellRenderer basicStyleListCellRenderer = new BasicStyleListCellRenderer();
    BasicStylePanel basicStylePanel;
    private TableCellEditor basicStyleTableCellEditor = new TableCellEditor(){
        private DefaultComboBoxModel comboBoxModel = new DefaultComboBoxModel();
        private BasicStyle originalStyle;
        private DefaultCellEditor editor;
        private JComboBox comboBox = new JComboBox(this.comboBoxModel){

            @Override
            public void setSelectedItem(Object anObject) {
                if (anObject != ColorThemingStylePanel.CUSTOM_ENTRY) {
                    super.setSelectedItem(anObject);
                    return;
                }
                BasicStyle style = ColorThemingStylePanel.this.promptBasicStyle(originalStyle);
                if (style == null) {
                    return;
                }
                comboBox.addItem(style);
                super.setSelectedItem(style);
            }
        };
        {
            this.comboBox.setRenderer(ColorThemingStylePanel.this.basicStyleListCellRenderer);
            this.editor = new DefaultCellEditor(this.comboBox);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.originalStyle = (BasicStyle)value;
            this.comboBoxModel.removeAllElements();
            this.comboBoxModel.addElement(ColorThemingStylePanel.CUSTOM_ENTRY);
            this.comboBoxModel.addElement(value);
            for (Color color : ColorScheme.create((String)ColorThemingStylePanel.this.colorSchemeComboBox.getSelectedItem()).getColors()) {
                this.comboBoxModel.addElement(new BasicStyle(color));
            }
            this.comboBoxModel.setSelectedItem(value);
            return this.editor.getTableCellEditorComponent(table, value, isSelected, row, column);
        }

        @Override
        public Object getCellEditorValue() {
            return this.editor.getCellEditorValue();
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            return this.editor.isCellEditable(anEvent);
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return this.editor.shouldSelectCell(anEvent);
        }

        @Override
        public boolean stopCellEditing() {
            return this.editor.stopCellEditing();
        }

        @Override
        public void cancelCellEditing() {
            this.editor.cancelCellEditing();
        }

        @Override
        public void addCellEditorListener(CellEditorListener l) {
            this.editor.addCellEditorListener(l);
        }

        @Override
        public void removeCellEditorListener(CellEditorListener l) {
            this.editor.removeCellEditorListener(l);
        }
    };
    private DefaultComboBoxModel comboBoxModel = new DefaultComboBoxModel();
    private JPanel fillerPanel = new JPanel();
    private String lastAttributeName;
    private ColorScheme colorSchemeForInserts = null;
    private MyPlugIn insertPlugIn = new MyPlugIn(){

        @Override
        public String getName() {
            return "Insert Row";
        }

        @Override
        public Icon getIcon() {
            return GUIUtil.toSmallIcon(IconLoader.icon("Plus.gif"));
        }

        @Override
        public boolean execute(PlugInContext context) throws Exception {
            this.reportNothingToUndoYet(context);
            ColorThemingStylePanel.this.stopCellEditing();
            ColorThemingStylePanel.this.tableModel().insertAttributeValue(ColorThemingStylePanel.this.table.getSelectedRowCount() > 0 ? ColorThemingStylePanel.this.table.getSelectedRows()[0] : ColorThemingStylePanel.this.table.getRowCount(), ColorThemingStylePanel.this.getColorSchemeForInserts());
            if (ColorThemingStylePanel.this.table.getSelectedRowCount() == 0) {
                ColorThemingStylePanel.this.table.scrollRectToVisible(ColorThemingStylePanel.this.table.getCellRect(ColorThemingStylePanel.this.table.getRowCount() - 1, 0, true));
            }
            if (ColorThemingStylePanel.this.table.getSelectedRowCount() != 0) {
                int firstSelectedRow = ColorThemingStylePanel.this.table.getSelectedRows()[0];
                ColorThemingStylePanel.this.table.clearSelection();
                ColorThemingStylePanel.this.table.addRowSelectionInterval(firstSelectedRow, firstSelectedRow);
            }
            return true;
        }
    };
    private MyPlugIn deletePlugIn = new MyPlugIn(){

        @Override
        public String getName() {
            return "Delete Row";
        }

        @Override
        public Icon getIcon() {
            return GUIUtil.toSmallIcon(IconLoader.icon("Delete.gif"));
        }

        @Override
        public boolean execute(PlugInContext context) throws Exception {
            this.reportNothingToUndoYet(context);
            ColorThemingStylePanel.this.stopCellEditing();
            ColorThemingStylePanel.this.tableModel().removeAttributeValues(ColorThemingStylePanel.this.table.getSelectedRows());
            return true;
        }
    };
    private HashSet errorMessages = new HashSet();
    private DiscreteColorThemingState discreteColorThemingState = new DiscreteColorThemingState(this.table);
    private RangeColorThemingState rangeColorThemingState;
    private State state = this.discreteColorThemingState;
    private JPanel jPanel5 = new JPanel();
    private GridBagLayout gridBagLayout3 = new GridBagLayout();
    private JCheckBox enableColorThemingCheckBox = new JCheckBox();
    private JCheckBox byRangeCheckBox = new JCheckBox();
    private JSlider transparencySlider = new JSlider();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColorThemingStylePanel(Layer layer, WorkbenchContext workbenchContext) {
        try {
            this.basicStylePanel = new BasicStylePanel(workbenchContext.getWorkbench().getBlackboard(), 22);
            this.layer = layer;
            this.workbenchContext = workbenchContext;
            this.rangeColorThemingState = new RangeColorThemingState(this);
            this.jbInit();
            this.byRangeCheckBox.setSelected(this.colorThemingStyleHasRanges(layer));
            this.state = this.byRangeCheckBox.isSelected() ? this.rangeColorThemingState : this.discreteColorThemingState;
            this.initTable(layer);
            this.setState(this.state);
            this.initAttributeNameComboBox(layer);
            this.initColorSchemeComboBox(layer.getLayerManager());
            this.initTransparencySlider(layer);
            this.initToolBar();
            this.enableColorThemingCheckBox.setSelected(ColorThemingStyle.get(layer).isEnabled());
            this.updateComponents();
            GUIUtil.sync(this.basicStylePanel.getTransparencySlider(), this.transparencySlider);
            this.basicStylePanel.setSynchronizingLineColor(layer.isSynchronizingLineColor());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.initializing = false;
        }
    }

    private void updateBackground(JComponent component) {
        component.setBackground(this.enableColorThemingCheckBox.isSelected() ? Color.white : this.jPanel1.getBackground());
    }

    private int attributeColumn() {
        return this.table.convertColumnIndexToView(1);
    }

    private int colorColumn() {
        return this.table.convertColumnIndexToView(0);
    }

    @Override
    public String getTitle() {
        return TITLE;
    }

    @Override
    public void updateStyles() {
        boolean firingEvents = this.layer.getLayerManager().isFiringEvents();
        this.layer.getLayerManager().setFiringEvents(false);
        try {
            this.layer.removeStyle(ColorThemingStyle.get(this.layer));
            this.layer.addStyle(new ColorThemingStyle(this.getAttributeName(), this.state.toExternalFormat(this.tableModel().getAttributeValueToBasicStyleMap()), this.tableModel().getDefaultStyle()));
            ColorThemingStyle.get(this.layer).setAlpha(this.getAlpha());
            ColorThemingStyle.get(this.layer).setEnabled(this.enableColorThemingCheckBox.isSelected());
            this.layer.getBasicStyle().setEnabled(!this.enableColorThemingCheckBox.isSelected());
        }
        finally {
            this.layer.getLayerManager().setFiringEvents(firingEvents);
        }
        this.layer.fireAppearanceChanged();
    }

    private String getAttributeName() {
        return (String)this.attributeNameComboBox.getSelectedItem();
    }

    private void stopCellEditing() {
        if (this.table.getCellEditor() instanceof DefaultCellEditor) {
            ((DefaultCellEditor)this.table.getCellEditor()).stopCellEditing();
        }
    }

    public JCheckBox getSynchronizeCheckBox() {
        return this.basicStylePanel.getSynchronizeCheckBox();
    }

    public Layer getLayer() {
        return this.layer;
    }

    private void initTransparencySlider(Layer layer) {
        this.transparencySlider.setValue(this.transparencySlider.getMaximum() - ColorThemingStyle.get(layer).getDefaultStyle().getAlpha());
        this.transparencySlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ColorThemingStylePanel.this.basicStyleListCellRenderer.setAlpha(ColorThemingStylePanel.this.getAlpha());
            }
        });
        this.basicStyleListCellRenderer.setAlpha(this.getAlpha());
    }

    private boolean colorThemingStyleHasRanges(Layer layer) {
        return !ColorThemingStyle.get(layer).getAttributeValueToBasicStyleMap().isEmpty() && ColorThemingStyle.get(layer).getAttributeValueToBasicStyleMap().keySet().iterator().next() instanceof Range;
    }

    private void initToolBar() {
        EnableCheck atLeast1RowMustBeSelectedCheck = new EnableCheck(){

            @Override
            public String check(JComponent component) {
                return ColorThemingStylePanel.this.table.getSelectedRowCount() == 0 ? "At least 1 row must be selected" : null;
            }
        };
        EnableCheck layerMustHaveAtLeast1AttributeCheck = new EnableCheck(){

            @Override
            public String check(JComponent component) {
                return ColorThemingStylePanel.this.attributeNameComboBox.getItemCount() == 0 ? "Layer must have at least 1 attribute" : null;
            }
        };
        EnableCheck colorThemingMustBeEnabledCheck = new EnableCheck(){

            @Override
            public String check(JComponent component) {
                return !ColorThemingStylePanel.this.enableColorThemingCheckBox.isSelected() ? "Colour theming must be enabled" : null;
            }
        };
        this.addPlugIn(this.insertPlugIn, new MultiEnableCheck().add(layerMustHaveAtLeast1AttributeCheck).add(colorThemingMustBeEnabledCheck));
        this.addPlugIn(this.deletePlugIn, new MultiEnableCheck().add(layerMustHaveAtLeast1AttributeCheck).add(atLeast1RowMustBeSelectedCheck).add(colorThemingMustBeEnabledCheck));
    }

    private void addPlugIn(MyPlugIn plugIn, EnableCheck enableCheck) {
        JButton button = new JButton();
        this.toolBar.add(button, plugIn.getName(), plugIn.getIcon(), AbstractPlugIn.toActionListener(plugIn, this.workbenchContext, null), enableCheck);
    }

    private void updateComponents() {
        if (this.updatingComponents) {
            return;
        }
        this.updatingComponents = true;
        try {
            this.attributeLabel.setEnabled(this.enableColorThemingCheckBox.isSelected());
            this.attributeNameComboBox.setEnabled(this.enableColorThemingCheckBox.isSelected());
            this.state.getPanel().setEnabled(this.enableColorThemingCheckBox.isSelected() && this.attributeNameComboBox.getItemCount() > 0);
            this.colorSchemeLabel.setEnabled(this.enableColorThemingCheckBox.isSelected() && this.attributeNameComboBox.getItemCount() > 0);
            this.byRangeCheckBox.setEnabled(this.enableColorThemingCheckBox.isSelected() && this.attributeNameComboBox.getItemCount() > 0);
            this.colorSchemeComboBox.setEnabled(this.enableColorThemingCheckBox.isSelected() && this.attributeNameComboBox.getItemCount() > 0);
            this.table.setEnabled(this.enableColorThemingCheckBox.isSelected() && this.attributeNameComboBox.getItemCount() > 0);
            this.scrollPane.setEnabled(this.enableColorThemingCheckBox.isSelected() && this.attributeNameComboBox.getItemCount() > 0);
            this.transparencySlider.setEnabled(this.enableColorThemingCheckBox.isSelected() && this.attributeNameComboBox.getItemCount() > 0);
            this.statusLabel.setEnabled(this.enableColorThemingCheckBox.isSelected());
            this.toolBar.updateEnabledState();
            if (!this.setErrorMessage(new ErrorMessage("Cannot colour-theme layer with no attributes"), this.attributeNameComboBox.getItemCount() == 0)) {
                this.setErrorMessage(new ErrorMessage("Table must not be empty"), this.table.getRowCount() == 0);
            }
            this.updateErrorDisplay();
            if (this.table.getColumnCount() > 0) {
                this.table.getColumnModel().getColumn(this.table.convertColumnIndexToView(1)).setHeaderValue(this.state.getAttributeValueColumnTitle());
            }
        }
        finally {
            this.updatingComponents = false;
        }
    }

    private BasicStyle promptBasicStyle(BasicStyle basicStyle) {
        int originalTransparencySliderValue = this.transparencySlider.getValue();
        this.basicStylePanel.setBasicStyle(basicStyle);
        this.basicStylePanel.getTransparencySlider().setValue(originalTransparencySliderValue);
        OKCancelPanel okCancelPanel = new OKCancelPanel();
        final JDialog dialog = new JDialog((JDialog)SwingUtilities.windowForComponent(this), "Custom", true);
        dialog.getContentPane().setLayout(new BorderLayout());
        dialog.getContentPane().add((Component)this.basicStylePanel, "Center");
        dialog.getContentPane().add((Component)okCancelPanel, "South");
        okCancelPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.setVisible(false);
            }
        });
        dialog.pack();
        GUIUtil.centreOnWindow(dialog);
        dialog.setVisible(true);
        if (!okCancelPanel.wasOKPressed()) {
            this.transparencySlider.setValue(originalTransparencySliderValue);
        }
        return okCancelPanel.wasOKPressed() ? this.basicStylePanel.getBasicStyle() : null;
    }

    private void initTable(Layer layer) {
        this.table.setModel(new ColorThemingTableModel(ColorThemingStyle.get(layer).getDefaultStyle(), ColorThemingStyle.get(layer).getAttributeName(), this.attributeValueToBasicStyleMap(layer), layer.getFeatureCollectionWrapper().getFeatureSchema()){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                if (rowIndex == 0 && columnIndex == 1) {
                    return ColorThemingStylePanel.this.state.getAllOtherValuesDescription();
                }
                return super.getValueAt(rowIndex, columnIndex);
            }
        });
        this.table.createDefaultColumnsFromModel();
        this.table.setRowSelectionAllowed(true);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ColorThemingStylePanel.this.updateComponents();
            }
        });
        this.table.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 1 && ColorThemingStylePanel.this.table.isEnabled()) {
                    ColorThemingStylePanel.this.tableModel().sort();
                }
            }
        });
        this.table.getColumnModel().getColumn(this.colorColumn()).setCellRenderer(new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JComponent renderer = (JComponent)ColorThemingStylePanel.this.basicStyleListCellRenderer.getListCellRendererComponent(new JList(), value, row, isSelected, hasFocus);
                if (!isSelected) {
                    ColorThemingStylePanel.this.updateBackground(renderer);
                }
                return renderer;
            }
        });
        this.table.getColumnModel().getColumn(this.colorColumn()).setCellEditor(this.basicStyleTableCellEditor);
        this.table.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                ColorThemingStylePanel.this.updateComponents();
                Object duplicateAttributeValue = ColorThemingStylePanel.this.tableModel().findDuplicateAttributeValue();
                ColorThemingStylePanel.this.setErrorMessage(new ErrorMessage("Table must not have duplicate attribute values ", "(" + duplicateAttributeValue + ")"), duplicateAttributeValue != null);
                ColorThemingStylePanel.this.setErrorMessage(new ErrorMessage("Table must not have null attribute values"), ColorThemingStylePanel.this.tableModel().containsNullAttributeValues());
            }
        });
        int colorWidth = 10 + (int)this.basicStyleListCellRenderer.getListCellRendererComponent(new JList(), new BasicStyle(), 0, false, false).getPreferredSize().getWidth();
        this.table.getColumnModel().getColumn(this.colorColumn()).setPreferredWidth(colorWidth);
        this.table.getColumnModel().getColumn(this.colorColumn()).setMinWidth(colorWidth);
        this.table.getColumnModel().getColumn(this.colorColumn()).setMaxWidth(colorWidth);
    }

    private Map attributeValueToBasicStyleMap(Layer layer) {
        if (ColorThemingStyle.get(layer).getAttributeName() == null) {
            return new TreeMap();
        }
        if (!layer.getFeatureCollectionWrapper().getFeatureSchema().hasAttribute(ColorThemingStyle.get(layer).getAttributeName())) {
            return new TreeMap();
        }
        return this.state.fromExternalFormat(ColorThemingStyle.get(layer).getAttributeValueToBasicStyleMap());
    }

    private void initColorSchemeComboBox(LayerManager layerManager) {
        this.colorSchemeComboBox.setRenderer(new ColorSchemeListCellRenderer(){

            @Override
            protected void color(ColorPanel colorPanel, Color fillColor, Color lineColor) {
                super.color(colorPanel, GUIUtil.alphaColor(fillColor, ColorThemingStylePanel.this.getAlpha()), GUIUtil.alphaColor(lineColor, ColorThemingStylePanel.this.getAlpha()));
            }

            @Override
            protected ColorScheme colorScheme(String name) {
                return ColorThemingStylePanel.this.state.filterColorScheme(super.colorScheme(name));
            }
        });
    }

    private int getAlpha() {
        return this.transparencySlider.getMaximum() - this.transparencySlider.getValue();
    }

    private void initAttributeNameComboBox(Layer layer) {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        for (int i = 0; i < layer.getFeatureCollectionWrapper().getFeatureSchema().getAttributeCount(); ++i) {
            if (i == layer.getFeatureCollectionWrapper().getFeatureSchema().getGeometryIndex()) continue;
            model.addElement(layer.getFeatureCollectionWrapper().getFeatureSchema().getAttributeName(i));
        }
        this.attributeNameComboBox.setModel(model);
        if (model.getSize() == 0) {
            return;
        }
        this.attributeNameComboBox.setSelectedItem(ColorThemingStyle.get(layer).getAttributeName());
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.jPanel1.setLayout(this.gridBagLayout2);
        this.jPanel3.setLayout(this.gridBagLayout4);
        this.attributeLabel.setText("Attribute: ");
        this.statusLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.statusLabel.setText(" ");
        this.jPanel4.setLayout(this.gridBagLayout5);
        this.colorSchemeLabel.setText("Colour Scheme: ");
        this.attributeNameComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorThemingStylePanel.this.attributeNameComboBox_actionPerformed(e);
            }
        });
        this.colorSchemeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorThemingStylePanel.this.colorSchemeComboBox_actionPerformed(e);
            }
        });
        this.jPanel5.setLayout(this.gridBagLayout3);
        this.enableColorThemingCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorThemingStylePanel.this.enableColorThemingCheckBox_actionPerformed(e);
            }
        });
        this.enableColorThemingCheckBox.setText("Enable colour theming");
        this.byRangeCheckBox.setText("by range");
        this.byRangeCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorThemingStylePanel.this.byRangeCheckBox_actionPerformed(e);
            }
        });
        this.transparencySlider.setMaximum(255);
        this.transparencySlider.setPreferredSize(new Dimension(75, 24));
        this.transparencySlider.setMinimumSize(new Dimension(75, 24));
        this.transparencySlider.setToolTipText("Transparency");
        this.transparencySlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ColorThemingStylePanel.this.transparencySlider_stateChanged(e);
            }
        });
        this.add((Component)this.jPanel1, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.attributeNameComboBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.jPanel1.add((Component)this.attributeLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.jPanel1.add((Component)this.fillerPanel, new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)this.scrollPane, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)this.jPanel3, new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel3.add((Component)this.statusLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel3.add((Component)this.toolBar, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel3.add((Component)this.transparencySlider, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jPanel4, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel4.add((Component)this.colorSchemeComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.jPanel4.add((Component)this.colorSchemeLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)this.jPanel5, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel5.add((Component)this.enableColorThemingCheckBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.jPanel5.add((Component)this.byRangeCheckBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.scrollPane.getViewport().add(this.table);
    }

    protected void enableColorThemingCheckBox_actionPerformed(ActionEvent e) {
        if (this.table.getRowCount() == 1) {
            this.populateTable();
        }
        this.updateComponents();
    }

    void attributeNameComboBox_actionPerformed(ActionEvent e) {
        try {
            if (this.initializing) {
                return;
            }
            if (this.attributeNameComboBox.getItemCount() == 0) {
                return;
            }
            if (this.attributeNameComboBox.getSelectedItem().equals(this.lastAttributeName)) {
                return;
            }
            this.stopCellEditing();
            this.populateTable();
        }
        finally {
            this.lastAttributeName = this.getAttributeName();
            if (this.table.getModel() instanceof ColorThemingTableModel) {
                this.tableModel().setAttributeName(this.getAttributeName());
            }
        }
    }

    public ColorThemingTableModel tableModel() {
        return (ColorThemingTableModel)this.table.getModel();
    }

    private SortedSet getNonNullAttributeValues() {
        TreeSet<Object> values = new TreeSet<Object>();
        for (Feature feature : this.layer.getFeatureCollectionWrapper().getFeatures()) {
            if (feature.getAttribute(this.getAttributeName()) == null) continue;
            values.add(ColorThemingStyle.trimIfString(feature.getAttribute(this.getAttributeName())));
        }
        return values;
    }

    public void populateTable() {
        if (!this.enableColorThemingCheckBox.isSelected() || this.attributeNameComboBox.getItemCount() <= 0) {
            return;
        }
        this.stopCellEditing();
        this.tableModel().clear();
        this.tableModel().setAttributeValueToBasicStyleMap(this.toAttributeValueToBasicStyleMap(this.state.filterAttributeValues(this.getNonNullAttributeValues())));
        this.tableModel().sort(this.tableModel().wasLastSortAscending());
        this.applyColorScheme();
    }

    private Map toAttributeValueToBasicStyleMap(Collection attributeValues) {
        TreeMap attributeValueToBasicStyleMap = new TreeMap();
        for (Object attributeValue : attributeValues) {
            attributeValueToBasicStyleMap.put(attributeValue, new BasicStyle());
        }
        return attributeValueToBasicStyleMap;
    }

    void colorSchemeComboBox_actionPerformed(ActionEvent e) {
        if (this.initializing) {
            return;
        }
        this.stopCellEditing();
        this.layer.getLayerManager().getBlackboard().put(COLOR_SCHEME_KEY, this.colorSchemeComboBox.getSelectedItem());
        this.applyColorScheme();
        this.colorSchemeForInserts = null;
    }

    private ColorScheme getColorSchemeForInserts() {
        if (this.colorSchemeForInserts == null || !this.colorSchemeForInserts.getName().equalsIgnoreCase((String)this.colorSchemeComboBox.getSelectedItem())) {
            this.colorSchemeForInserts = ColorScheme.create((String)this.colorSchemeComboBox.getSelectedItem());
        }
        return this.colorSchemeForInserts;
    }

    public void applyColorScheme() {
        this.stopCellEditing();
        this.state.applyColorScheme(this.state.filterColorScheme(ColorScheme.create((String)this.colorSchemeComboBox.getSelectedItem())));
    }

    private void cancelCellEditing() {
        if (this.table.getCellEditor() instanceof DefaultCellEditor) {
            ((DefaultCellEditor)this.table.getCellEditor()).cancelCellEditing();
        }
    }

    @Override
    public String validateInput() {
        this.stopCellEditing();
        return this.internalValidateInput();
    }

    private String internalValidateInput() {
        if (!this.enableColorThemingCheckBox.isSelected()) {
            return null;
        }
        if (this.errorMessages.isEmpty()) {
            return null;
        }
        return this.errorMessages.iterator().next().toString();
    }

    private boolean setErrorMessage(ErrorMessage message, boolean enabled) {
        this.errorMessages.remove(message);
        if (enabled) {
            this.errorMessages.add(message);
        }
        this.updateErrorDisplay();
        return enabled;
    }

    private void updateErrorDisplay() {
        String errorMessage = this.internalValidateInput();
        if (errorMessage != null) {
            this.statusLabel.setText(errorMessage);
            this.statusLabel.setIcon(GUIUtil.toSmallIcon(IconLoader.icon("Delete.gif")));
        } else {
            this.statusLabel.setText(" ");
            this.statusLabel.setIcon(null);
        }
    }

    private void setState(State state) {
        this.state.deactivate();
        this.jPanel1.remove(this.state.getPanel());
        this.state = state;
        this.jPanel1.add((Component)state.getPanel(), new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.initializing = true;
        try {
            this.colorSchemeComboBox.setModel(new DefaultComboBoxModel(new Vector(state.getColorSchemeNames())));
            this.colorSchemeComboBox.setSelectedItem(this.layer.getLayerManager().getBlackboard().get(COLOR_SCHEME_KEY, this.colorSchemeComboBox.getItemAt(0)));
        }
        finally {
            this.initializing = false;
        }
        this.updateComponents();
        this.state.activate();
        this.jPanel1.repaint();
    }

    void byRangeCheckBox_actionPerformed(ActionEvent e) {
        this.setState(this.byRangeCheckBox.isSelected() ? this.rangeColorThemingState : this.discreteColorThemingState);
        this.populateTable();
    }

    void transparencySlider_stateChanged(ChangeEvent e) {
        this.repaint();
    }

    public JSlider getTransparencySlider() {
        return this.transparencySlider;
    }

    public JTable getTable() {
        return this.table;
    }

    private class ErrorMessage {
        private String commonPart;
        private String specificPart;

        public ErrorMessage(String commonPart) {
            this(commonPart, "");
        }

        public ErrorMessage(String commonPart, String specificPart) {
            this.commonPart = commonPart;
            this.specificPart = specificPart;
        }

        public int hashCode() {
            return this.commonPart.hashCode();
        }

        public boolean equals(Object obj) {
            return this.commonPart.equals(((ErrorMessage)obj).commonPart);
        }

        public String toString() {
            return this.commonPart + this.specificPart;
        }
    }

    private abstract class MyPlugIn
    extends AbstractPlugIn {
        private MyPlugIn() {
        }

        public abstract Icon getIcon();
    }

    public static interface State {
        public String getAllOtherValuesDescription();

        public ColorScheme filterColorScheme(ColorScheme var1);

        public void activate();

        public void deactivate();

        public Collection getColorSchemeNames();

        public void applyColorScheme(ColorScheme var1);

        public Collection filterAttributeValues(SortedSet var1);

        public String getAttributeValueColumnTitle();

        public JComponent getPanel();

        public Map toExternalFormat(Map var1);

        public Map fromExternalFormat(Map var1);
    }
}

