/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui.snap;

import java.awt.Color;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.Collection;
import javax.swing.Icon;
import org.locationtech.jts.jump.workbench.ui.cursortool.AbstractCursorTool;
import org.locationtech.jts.util.Assert;

public class SnapIndicatorTool
extends AbstractCursorTool {
    private Point2D indicatorLocation;
    private Color snappedColor;
    private Color unsnappedColor;
    private double diameter;

    public SnapIndicatorTool(Collection snapPolicies) {
        this(Color.green, Color.red, 8.0, snapPolicies);
    }

    public SnapIndicatorTool(Color snappedColor, Color unsnappedColor, double diameter, Collection snapPolicies) {
        this.getSnapManager().addPolicies(snapPolicies);
        this.setFilling(true);
        this.snappedColor = snappedColor;
        this.unsnappedColor = unsnappedColor;
        this.diameter = diameter;
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    protected void gestureFinished() throws Exception {
        Assert.shouldNeverReachHere();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.mouseLocationChanged(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.mouseLocationChanged(e);
    }

    @Override
    protected Shape getShape() throws NoninvertibleTransformException {
        return new Ellipse2D.Double(this.indicatorLocation.getX() - this.diameter / 2.0, this.indicatorLocation.getY() - this.diameter / 2.0, this.diameter, this.diameter);
    }

    private void mouseLocationChanged(MouseEvent e) {
        try {
            this.clearShape();
            this.indicatorLocation = this.getPanel().getViewport().toViewPoint(this.snap(e.getPoint()));
            this.setColor(this.getSnapManager().wasSnapCoordinateFound() ? this.snappedColor : this.unsnappedColor);
            this.redrawShape();
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    @Override
    public boolean isGestureInProgress() {
        return false;
    }
}

