/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui.snap;

import java.util.ArrayList;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.jump.geom.CoordUtil;
import org.locationtech.jts.jump.util.Blackboard;
import org.locationtech.jts.jump.workbench.ui.LayerViewPanel;
import org.locationtech.jts.jump.workbench.ui.plugin.VerticesInFencePlugIn;
import org.locationtech.jts.jump.workbench.ui.snap.SnapManager;
import org.locationtech.jts.jump.workbench.ui.snap.SnapPolicy;
import org.locationtech.jts.jump.workbench.ui.snap.VisiblePointsAndLinesCache;

public class SnapToVerticesPolicy
implements SnapPolicy {
    private GeometryFactory factory = new GeometryFactory();
    private Blackboard blackboard;
    public static final String ENABLED_KEY = SnapToVerticesPolicy.class.getName() + " - ENABLED";

    public SnapToVerticesPolicy(Blackboard blackboard) {
        this.blackboard = blackboard;
    }

    @Override
    public Coordinate snap(LayerViewPanel panel, Coordinate originalPoint) {
        if (!this.blackboard.get(ENABLED_KEY, false)) {
            return null;
        }
        Geometry bufferedTransformedCursorLocation = this.factory.createPoint(originalPoint).buffer((double)SnapManager.getToleranceInPixels(this.blackboard) / panel.getViewport().getScale());
        ArrayList vertices = new ArrayList();
        for (Geometry pointsAndLines : VisiblePointsAndLinesCache.instance(panel).getTree().query(bufferedTransformedCursorLocation.getEnvelopeInternal())) {
            vertices.addAll(VerticesInFencePlugIn.verticesInFence(pointsAndLines, bufferedTransformedCursorLocation, true).getCoordinates());
        }
        if (vertices.isEmpty()) {
            return null;
        }
        return CoordUtil.closest(vertices, originalPoint);
    }
}

