/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui.style;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.locationtech.jts.jump.workbench.WorkbenchContext;
import org.locationtech.jts.jump.workbench.model.Layer;
import org.locationtech.jts.jump.workbench.model.UndoableCommand;
import org.locationtech.jts.jump.workbench.plugin.AbstractPlugIn;
import org.locationtech.jts.jump.workbench.plugin.EnableCheck;
import org.locationtech.jts.jump.workbench.plugin.EnableCheckFactory;
import org.locationtech.jts.jump.workbench.plugin.MultiEnableCheck;
import org.locationtech.jts.jump.workbench.plugin.PlugInContext;
import org.locationtech.jts.jump.workbench.ui.GUIUtil;
import org.locationtech.jts.jump.workbench.ui.MultiInputDialog;
import org.locationtech.jts.jump.workbench.ui.images.IconLoader;
import org.locationtech.jts.jump.workbench.ui.renderer.style.ColorThemingStylePanel;
import org.locationtech.jts.jump.workbench.ui.style.DecorationStylePanel;
import org.locationtech.jts.jump.workbench.ui.style.LabelStylePanel;
import org.locationtech.jts.jump.workbench.ui.style.RenderingStylePanel;
import org.locationtech.jts.jump.workbench.ui.style.StylePanel;
import org.locationtech.jts.util.Assert;

public class ChangeStylesPlugIn
extends AbstractPlugIn {
    private static final String LAST_TAB_KEY = ChangeStylesPlugIn.class.getName() + " - LAST TAB";

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        final Layer layer = context.getSelectedLayer(0);
        MultiInputDialog dialog = new MultiInputDialog(context.getWorkbenchFrame(), "Change Styles", true);
        dialog.setInset(0);
        dialog.setSideBarImage(IconLoader.icon("Symbology.gif"));
        dialog.setSideBarDescription("You can use this dialog to change the colour, line width, and other visual properties of a layer.");
        final ArrayList<JPanel> stylePanels = new ArrayList<JPanel>();
        RenderingStylePanel renderingStylePanel = new RenderingStylePanel(context.getWorkbenchContext().getWorkbench().getBlackboard(), layer);
        stylePanels.add(renderingStylePanel);
        DecorationStylePanel decorationStylePanel = new DecorationStylePanel(layer, context.getWorkbenchFrame().getChoosableStyleClasses());
        decorationStylePanel.setPreferredSize(new Dimension(400, 300));
        if (layer.getFeatureCollectionWrapper().getFeatureSchema().getAttributeCount() > 1) {
            ColorThemingStylePanel colorThemingStylePanel = new ColorThemingStylePanel(layer, context.getWorkbenchContext());
            colorThemingStylePanel.setPreferredSize(new Dimension(400, 300));
            stylePanels.add(colorThemingStylePanel);
            GUIUtil.sync(renderingStylePanel.getTransparencySlider(), colorThemingStylePanel.getTransparencySlider());
            GUIUtil.sync(renderingStylePanel.getSynchronizeCheckBox(), colorThemingStylePanel.getSynchronizeCheckBox());
        } else {
            stylePanels.add(new DummyColorThemingStylePanel());
        }
        stylePanels.add(new LabelStylePanel(layer, context.getLayerViewPanel(), dialog, context.getErrorHandler()));
        stylePanels.add(decorationStylePanel);
        JTabbedPane tabbedPane = new JTabbedPane();
        for (final StylePanel stylePanel : stylePanels) {
            tabbedPane.add((Component)((Object)stylePanel), stylePanel.getTitle());
            dialog.addEnableChecks(stylePanel.getTitle(), Arrays.asList(new EnableCheck(){

                @Override
                public String check(JComponent component) {
                    return stylePanel.validateInput();
                }
            }));
        }
        dialog.addRow(tabbedPane);
        tabbedPane.setSelectedComponent(this.find(stylePanels, (String)context.getWorkbenchContext().getWorkbench().getBlackboard().get(LAST_TAB_KEY, ((StylePanel)stylePanels.iterator().next()).getTitle())));
        dialog.setVisible(true);
        context.getWorkbenchContext().getWorkbench().getBlackboard().put(LAST_TAB_KEY, ((StylePanel)((Object)tabbedPane.getSelectedComponent())).getTitle());
        if (dialog.wasOKPressed()) {
            final Collection oldStyles = layer.cloneStyles();
            layer.getLayerManager().deferFiringEvents(new Runnable(){

                @Override
                public void run() {
                    for (StylePanel stylePanel : stylePanels) {
                        stylePanel.updateStyles();
                    }
                }
            });
            final Collection collection = layer.cloneStyles();
            this.execute(new UndoableCommand(this.getName()){

                @Override
                public void execute() {
                    layer.setStyles(collection);
                }

                @Override
                public void unexecute() {
                    layer.setStyles(oldStyles);
                }
            }, context);
            boolean firingEvents = layer.getLayerManager().isFiringEvents();
            layer.getLayerManager().setFiringEvents(false);
            layer.getLayerManager().setFiringEvents(firingEvents);
            layer.fireAppearanceChanged();
            return true;
        }
        return false;
    }

    private Component find(Collection stylePanels, String title) {
        for (StylePanel stylePanel : stylePanels) {
            if (!stylePanel.getTitle().equals(title)) continue;
            return (Component)((Object)stylePanel);
        }
        Assert.shouldNeverReachHere();
        return null;
    }

    public ImageIcon getIcon() {
        return IconLoader.icon("Palette.gif");
    }

    public MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createExactlyNLayersMustBeSelectedCheck(1));
    }

    private class DummyColorThemingStylePanel
    extends JPanel
    implements StylePanel {
        public DummyColorThemingStylePanel() {
            super(new GridBagLayout());
            this.add(new JLabel("This layer has no attributes."));
        }

        @Override
        public String getTitle() {
            return "Colour Theming";
        }

        @Override
        public void updateStyles() {
        }

        @Override
        public String validateInput() {
            return null;
        }
    }
}

