/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui.style;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.jump.feature.AttributeType;
import org.locationtech.jts.jump.feature.Feature;
import org.locationtech.jts.jump.feature.FeatureSchema;
import org.locationtech.jts.jump.feature.FeatureUtil;
import org.locationtech.jts.jump.util.Blackboard;
import org.locationtech.jts.jump.workbench.model.Layer;
import org.locationtech.jts.jump.workbench.model.LayerManager;
import org.locationtech.jts.jump.workbench.ui.GUIUtil;
import org.locationtech.jts.jump.workbench.ui.LayerViewPanel;
import org.locationtech.jts.jump.workbench.ui.LayerViewPanelContext;
import org.locationtech.jts.jump.workbench.ui.Viewport;
import org.locationtech.jts.jump.workbench.ui.renderer.style.BasicStyle;
import org.locationtech.jts.jump.workbench.ui.renderer.style.Style;
import org.locationtech.jts.jump.workbench.ui.renderer.style.VertexStyle;
import org.locationtech.jts.jump.workbench.ui.style.BasicStylePanel;
import org.locationtech.jts.jump.workbench.ui.style.StylePanel;
import org.locationtech.jts.util.Assert;

public class RenderingStylePanel
extends BasicStylePanel
implements StylePanel {
    private Layer layer;
    private JTextArea fillPatternTipLabel = new JTextArea();
    private JCheckBox vertexCheckBox = new JCheckBox();
    private JSlider vertexSlider = new JSlider(){
        {
            this.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    RenderingStylePanel.this.updateControls();
                }
            });
        }
    };
    private JPanel previewPanel = new JPanel(){
        private LayerViewPanel dummyLayerViewPanel;
        private Viewport viewport;
        private Feature feature;
        {
            this.setBackground(Color.white);
            this.setBorder(BorderFactory.createLoweredBevelBorder());
            this.setMaximumSize(new Dimension(200, 40));
            this.setMinimumSize(new Dimension(200, 40));
            this.setPreferredSize(new Dimension(200, 40));
            this.dummyLayerViewPanel = new LayerViewPanel(new LayerManager(), new LayerViewPanelContext(){

                @Override
                public void setStatusMessage(String message) {
                }

                @Override
                public void warnUser(String warning) {
                }

                @Override
                public void handleThrowable(Throwable t) {
                }
            });
            this.viewport = new Viewport(this.dummyLayerViewPanel){
                private AffineTransform transform;
                {
                    this.transform = new AffineTransform();
                }

                @Override
                public Envelope getEnvelopeInModelCoordinates() {
                    return new Envelope(0.0, 200.0, 0.0, 40.0);
                }

                @Override
                public AffineTransform getModelToViewTransform() {
                    return this.transform;
                }

                @Override
                public Point2D toViewPoint(Coordinate modelCoordinate) {
                    return new Point2D.Double(modelCoordinate.x, modelCoordinate.y);
                }
            };
            this.feature = this.createFeature();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void paint(Style style, Graphics2D g) {
            Stroke originalStroke = g.getStroke();
            try {
                style.paint(this.feature, g, this.viewport);
            }
            catch (Exception exception) {
            }
            finally {
                g.setStroke(originalStroke);
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.paint(RenderingStylePanel.this.getBasicStyle(), (Graphics2D)g);
            if (RenderingStylePanel.this.vertexCheckBox.isSelected()) {
                VertexStyle vertexStyle = RenderingStylePanel.this.getVertexStyle();
                vertexStyle.initialize(new Layer(){

                    @Override
                    public BasicStyle getBasicStyle() {
                        return RenderingStylePanel.this.getBasicStyle();
                    }
                });
                this.paint(vertexStyle, (Graphics2D)g);
            }
        }

        private Feature createFeature() {
            try {
                return FeatureUtil.toFeature(new WKTReader().read("POLYGON ((-200 80, 100 20, 400 -40, 400 80, -200 80))"), new FeatureSchema(){
                    private static final long serialVersionUID = -8627306219650589202L;
                    {
                        this.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
                    }
                });
            }
            catch (ParseException e) {
                Assert.shouldNeverReachHere();
                return null;
            }
        }
    };

    public RenderingStylePanel() {
    }

    public RenderingStylePanel(Blackboard blackboard, Layer layer) {
        super(blackboard, 21);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(new Integer(5), new JLabel("5"));
        labelTable.put(new Integer(10), new JLabel("10"));
        labelTable.put(new Integer(15), new JLabel("15"));
        labelTable.put(new Integer(20), new JLabel("20"));
        this.vertexSlider.setLabelTable(labelTable);
        this.setBasicStyle(layer.getBasicStyle());
        try {
            this.jbInit();
            this.updateControls();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.setLayer(layer);
    }

    @Override
    public void updateControls() {
        super.updateControls();
        if (this.vertexSlider == null) {
            return;
        }
        this.previewPanel.repaint();
        this.vertexSlider.setEnabled(this.vertexCheckBox.isSelected());
        Enumeration e = this.vertexSlider.getLabelTable().elements();
        while (e.hasMoreElements()) {
            JLabel label = (JLabel)e.nextElement();
            label.setEnabled(this.vertexCheckBox.isSelected());
        }
    }

    @Override
    public String getTitle() {
        return "Rendering";
    }

    private void setLayer(Layer layer) {
        this.layer = layer;
        this.setSynchronizingLineColor(layer.isSynchronizingLineColor());
        this.vertexCheckBox.setSelected(layer.getVertexStyle().isEnabled());
        this.vertexSlider.setValue(layer.getVertexStyle().getSize());
    }

    @Override
    void jbInit() throws Exception {
        if (this.vertexSlider == null) {
            super.jbInit();
            return;
        }
        this.vertexCheckBox.setText("Vertices. Size:");
        this.vertexCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RenderingStylePanel.this.showVerticesCheckBox_actionPerformed(e);
            }
        });
        this.vertexSlider.setMinorTickSpacing(1);
        this.vertexSlider.setMajorTickSpacing(0);
        this.vertexSlider.setPaintLabels(true);
        this.vertexSlider.setMinimum(4);
        this.vertexSlider.setValue(4);
        this.vertexSlider.setMaximum(20);
        this.vertexSlider.setSnapToTicks(true);
        this.vertexSlider.setPreferredSize(SLIDER_DIMENSION);
        this.fillPatternTipLabel.setFont(new Font("SansSerif", 2, 10));
        this.fillPatternTipLabel.setOpaque(false);
        this.fillPatternTipLabel.setEditable(false);
        this.fillPatternTipLabel.setText("Tip: After selecting a pattern, use your keyboard's up and down keys to see how other patterns look in the preview below");
        this.fillPatternTipLabel.setLineWrap(true);
        this.fillPatternTipLabel.setWrapStyleWord(true);
        this.centerPanel.add((Component)this.vertexSlider, new GridBagConstraints(1, 35, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.centerPanel.add((Component)GUIUtil.createSyncdTextField(this.vertexSlider, 3), new GridBagConstraints(2, 35, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.centerPanel.add((Component)this.vertexCheckBox, new GridBagConstraints(0, 35, 2, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.centerPanel.add((Component)new JLabel("Preview:"), new GridBagConstraints(0, 40, 3, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 0, 2), 0, 0));
        this.centerPanel.add((Component)this.previewPanel, new GridBagConstraints(0, 45, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 2, 2), 0, 0));
        this.centerPanel.add((Component)this.fillPatternTipLabel, new GridBagConstraints(0, 8, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public VertexStyle getVertexStyle() {
        VertexStyle vertexStyle = (VertexStyle)this.layer.getVertexStyle().clone();
        vertexStyle.setEnabled(this.vertexCheckBox.isSelected());
        vertexStyle.setSize(this.vertexSlider.getValue());
        return vertexStyle;
    }

    @Override
    public void updateStyles() {
        boolean firingEvents = this.layer.getLayerManager().isFiringEvents();
        this.layer.getLayerManager().setFiringEvents(false);
        try {
            this.layer.removeStyle(this.layer.getBasicStyle());
            this.layer.addStyle(this.getBasicStyle());
            VertexStyle newVertexStyle = this.getVertexStyle();
            this.layer.removeStyle(this.layer.getVertexStyle());
            this.layer.addStyle(newVertexStyle);
            this.layer.setSynchronizingLineColor(this.synchronizeCheckBox.isSelected());
        }
        finally {
            this.layer.getLayerManager().setFiringEvents(firingEvents);
        }
        this.layer.fireAppearanceChanged();
    }

    void showVerticesCheckBox_actionPerformed(ActionEvent e) {
        this.updateControls();
    }

    @Override
    public String validateInput() {
        return null;
    }
}

