/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui.task;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Date;
import javax.swing.Timer;
import org.locationtech.jts.jump.util.StringUtil;
import org.locationtech.jts.jump.workbench.plugin.PlugInContext;
import org.locationtech.jts.jump.workbench.plugin.ThreadedPlugIn;
import org.locationtech.jts.jump.workbench.ui.GUIUtil;
import org.locationtech.jts.jump.workbench.ui.WorkbenchFrame;
import org.locationtech.jts.jump.workbench.ui.task.TaskMonitorDialog;

public class TaskMonitorManager {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ThreadedPlugIn plugIn, PlugInContext context) {
        TaskMonitorDialog progressDialog = new TaskMonitorDialog((Frame)context.getWorkbenchFrame(), context.getErrorHandler());
        progressDialog.setTitle(plugIn.getName());
        final TaskWrapper taskWrapper = new TaskWrapper(plugIn, context, progressDialog);
        progressDialog.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                new Thread(taskWrapper).start();
            }
        });
        GUIUtil.centreOnWindow(progressDialog);
        Timer timer = this.timer(new Date(), plugIn, context.getWorkbenchFrame());
        timer.start();
        try {
            progressDialog.setVisible(true);
        }
        finally {
            timer.stop();
        }
    }

    private Timer timer(final Date start, final ThreadedPlugIn plugIn, final WorkbenchFrame workbenchFrame) {
        return new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String message = "";
                message = message + StringUtil.toTimeString(new Date().getTime() - start.getTime());
                message = message + " (" + plugIn.getName() + ")";
                workbenchFrame.setTimeMessage(message);
            }
        });
    }

    private class TaskWrapper
    implements Runnable {
        private ThreadedPlugIn plugIn;
        private PlugInContext context;
        private TaskMonitorDialog dialog;

        public TaskWrapper(ThreadedPlugIn plugIn, PlugInContext context, TaskMonitorDialog dialog) {
            this.plugIn = plugIn;
            this.context = context;
            this.dialog = dialog;
        }

        @Override
        public void run() {
            Throwable throwable = null;
            try {
                this.plugIn.run(this.dialog, this.context);
            }
            catch (Throwable t) {
                throwable = t;
            }
            finally {
                this.dialog.setVisible(false);
                if (throwable != null) {
                    this.context.getErrorHandler().handleThrowable(throwable);
                }
                this.context = null;
            }
        }
    }
}

