/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui.warp;

import java.awt.geom.NoninvertibleTransformException;
import java.util.ArrayList;
import java.util.Collection;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.jump.feature.Feature;
import org.locationtech.jts.jump.geom.EnvelopeUtil;
import org.locationtech.jts.jump.workbench.model.AbstractVectorLayerFinder;
import org.locationtech.jts.jump.workbench.model.LayerManagerProxy;
import org.locationtech.jts.jump.workbench.model.UndoableCommand;
import org.locationtech.jts.jump.workbench.ui.cursortool.Animations;
import org.locationtech.jts.jump.workbench.ui.cursortool.SpecifyFeaturesTool;
import org.locationtech.jts.util.Assert;

public abstract class AbstractDeleteVectorTool
extends SpecifyFeaturesTool {
    public AbstractDeleteVectorTool() {
        this.setViewClickBuffer(6);
    }

    private void showAnimation(Collection vectorFeatures) {
        try {
            Animations.drawExpandingRings(this.getPanel().getViewport().toViewPoints(this.centres(vectorFeatures)), true, this.getColor(), this.getPanel(), new float[]{15.0f, 15.0f});
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
    }

    private Collection centres(Collection vectorFeatures) {
        ArrayList<Coordinate> centers = new ArrayList<Coordinate>();
        for (Feature vectorFeature : vectorFeatures) {
            Envelope envelope = vectorFeature.getGeometry().getEnvelopeInternal();
            if (envelope.isNull()) continue;
            centers.add(EnvelopeUtil.centre(envelope));
        }
        return centers;
    }

    protected abstract AbstractVectorLayerFinder createVectorLayerFinder(LayerManagerProxy var1);

    @Override
    protected void gestureFinished() throws Exception {
        this.reportNothingToUndoYet();
        AbstractVectorLayerFinder finder = this.createVectorLayerFinder(this.getPanel());
        if (finder.getLayer() == null) {
            return;
        }
        if (!this.layerToSpecifiedFeaturesMap().containsKey(finder.getLayer())) {
            return;
        }
        this.execute(this.createCommand());
    }

    protected UndoableCommand createCommand() throws NoninvertibleTransformException {
        final AbstractVectorLayerFinder finder = this.createVectorLayerFinder(this.getPanel());
        final Collection vectorFeaturesToDelete = (Collection)this.layerToSpecifiedFeaturesMap().get(finder.getLayer());
        Assert.isTrue((vectorFeaturesToDelete != null ? 1 : 0) != 0);
        Assert.isTrue((!vectorFeaturesToDelete.isEmpty() ? 1 : 0) != 0);
        return new UndoableCommand(this.getName()){

            @Override
            public void execute() {
                finder.getLayer().getFeatureCollectionWrapper().removeAll(vectorFeaturesToDelete);
                AbstractDeleteVectorTool.this.showAnimation(vectorFeaturesToDelete);
            }

            @Override
            public void unexecute() {
                finder.getLayer().getFeatureCollectionWrapper().addAll(vectorFeaturesToDelete);
            }
        };
    }
}

