/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui.warp;

import java.awt.Component;
import javax.swing.JComponent;
import org.locationtech.jts.jump.workbench.plugin.EnableCheck;
import org.locationtech.jts.jump.workbench.plugin.PlugInContext;
import org.locationtech.jts.jump.workbench.ui.GUIUtil;
import org.locationtech.jts.jump.workbench.ui.cursortool.CursorTool;
import org.locationtech.jts.jump.workbench.ui.images.IconLoader;
import org.locationtech.jts.jump.workbench.ui.toolbox.ToolboxDialog;
import org.locationtech.jts.jump.workbench.ui.toolbox.ToolboxPlugIn;
import org.locationtech.jts.jump.workbench.ui.warp.DeleteIncrementalWarpingVectorTool;
import org.locationtech.jts.jump.workbench.ui.warp.DeleteWarpingVectorTool;
import org.locationtech.jts.jump.workbench.ui.warp.DrawIncrementalWarpingVectorTool;
import org.locationtech.jts.jump.workbench.ui.warp.DrawWarpingVectorTool;
import org.locationtech.jts.jump.workbench.ui.warp.WarpingPanel;

public class WarpingPlugIn
extends ToolboxPlugIn {
    @Override
    public void initialize(PlugInContext context) throws Exception {
        this.createMainMenuItem(new String[]{"Tools", "Warping"}, GUIUtil.toSmallIcon(IconLoader.icon("GoalFlag.gif")), context.getWorkbenchContext());
    }

    @Override
    protected void initializeToolbox(ToolboxDialog toolbox) {
        WarpingPanel warpingPanel = new WarpingPanel(toolbox);
        toolbox.getCenterPanel().add((Component)warpingPanel, "Center");
        this.add(new DrawWarpingVectorTool(), false, toolbox, warpingPanel);
        this.add(new DeleteWarpingVectorTool(), false, toolbox, warpingPanel);
        toolbox.getToolBar().addSeparator();
        this.add(new DrawIncrementalWarpingVectorTool(warpingPanel), true, toolbox, warpingPanel);
        this.add(new DeleteIncrementalWarpingVectorTool(warpingPanel), true, toolbox, warpingPanel);
        toolbox.setInitialLocation(new GUIUtil.Location(20, true, 175, false));
    }

    private void add(CursorTool tool, final boolean incremental, ToolboxDialog toolbox, final WarpingPanel warpingPanel) {
        toolbox.add(tool, new EnableCheck(){

            @Override
            public String check(JComponent component) {
                if (incremental && warpingPanel.isWarpingIncrementally()) {
                    return null;
                }
                if (!incremental && !warpingPanel.isWarpingIncrementally()) {
                    return null;
                }
                return "Incremental warping must be " + (incremental ? "enabled" : "disabled");
            }
        });
    }
}

