/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui.zoom;

import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.locationtech.jts.jump.workbench.WorkbenchContext;
import org.locationtech.jts.jump.workbench.plugin.AbstractPlugIn;
import org.locationtech.jts.jump.workbench.plugin.EnableCheck;
import org.locationtech.jts.jump.workbench.plugin.EnableCheckFactory;
import org.locationtech.jts.jump.workbench.plugin.MultiEnableCheck;
import org.locationtech.jts.jump.workbench.plugin.PlugInContext;
import org.locationtech.jts.jump.workbench.ui.Viewport;
import org.locationtech.jts.jump.workbench.ui.images.IconLoader;
import org.locationtech.jts.util.Assert;

public class ZoomNextPlugIn
extends AbstractPlugIn {
    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        Viewport viewport = context.getLayerViewPanel().getViewport();
        Assert.isTrue((boolean)viewport.getZoomHistory().hasNext());
        viewport.getZoomHistory().setAdding(false);
        try {
            viewport.zoom(viewport.getZoomHistory().next());
        }
        finally {
            viewport.getZoomHistory().setAdding(true);
        }
        return true;
    }

    public MultiEnableCheck createEnableCheck(final WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(new EnableCheck(){

            @Override
            public String check(JComponent component) {
                return !workbenchContext.getLayerViewPanel().getViewport().getZoomHistory().hasNext() ? "Already at end" : null;
            }
        });
    }

    public ImageIcon getIcon() {
        return IconLoader.icon("Right.gif");
    }
}

