package org.locationtech.jts.jump.workbench.ui.plugin;

import org.locationtech.jts.jump.workbench.WorkbenchContext;
import org.locationtech.jts.jump.workbench.plugin.*;

import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;


public class MapToolTipsPlugIn extends AbstractPlugIn {
    public static MultiEnableCheck createEnableCheck(final WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(
            checkFactory
                .createWindowWithLayerNamePanelMustBeActiveCheck())
                .add(new EnableCheck() {
            public String check(JComponent component) {
                ((JCheckBoxMenuItem) component).setSelected(
                    workbenchContext.getLayerViewPanel().getToolTipWriter().isEnabled());
                return null;
            }
        });
    }
    public String getName() {
        //Can't use auto-naming, which produces "Map Tool Tips"; and Unix/Windows
        //CVS issues will occur if I rename MapToolTipsPlugIn to MapTooltipsPlugIn. [Jon Aquino]
		return "Map Tooltips";
	}
    public boolean execute(PlugInContext context) throws Exception {
        context.getLayerViewPanel().getToolTipWriter().setEnabled(
            !context.getLayerViewPanel().getToolTipWriter().isEnabled());
        return true;
    }
}
