
/*
 * The Unified Mapping Platform (JUMP) is an extensible, interactive GUI 
 * for visualizing and manipulating spatial features with geometry and attributes.
 *
 * Copyright (C) 2003 Vivid Solutions
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * For more information, contact:
 *
 * Vivid Solutions
 * Suite #1A
 * 2328 Government Street
 * Victoria BC  V8T 5G5
 * Canada
 *
 * (250)385-6040
 * www.vividsolutions.com
 */

package org.locationtech.jts.jump.workbench.ui.renderer.style;

import java.awt.Graphics2D;

import org.locationtech.jts.jump.workbench.model.Layer;
import org.locationtech.jts.jump.feature.Feature;
import org.locationtech.jts.jump.workbench.ui.Viewport;


/**
 * Must have a parameterless constructor so it can be created by Java2XML.
 */
public interface Style extends Cloneable {
    public void paint(Feature f, Graphics2D g, Viewport viewport)
        throws Exception;

    /**
     * Called before #paint is applied to each Feature.
     * @return false if #paint should not be called e.g. because vertices are not
     * shown. Don't need to check whether the layer is visible.
     */
    public void initialize(Layer layer);

    public Object clone();

    public void setEnabled(boolean enabled);

    public boolean isEnabled();

}
