/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.shapefile;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import org.geotools.shapefile.InvalidShapefileException;
import org.geotools.shapefile.ShapeHandler;
import org.locationtech.jts.algorithm.CGAlgorithms;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.jump.io.EndianDataInputStream;
import org.locationtech.jts.jump.io.EndianDataOutputStream;

public class PolygonHandler
implements ShapeHandler {
    protected static CGAlgorithms cga = new CGAlgorithms();
    int myShapeType;

    public PolygonHandler() {
        this.myShapeType = 5;
    }

    public PolygonHandler(int type) throws InvalidShapefileException {
        if (type != 5 && type != 15 && type != 25) {
            throw new InvalidShapefileException("PolygonHandler constructor - expected type to be 5, 15, or 25.");
        }
        this.myShapeType = type;
    }

    boolean pointInList(Coordinate testPoint, Coordinate[] pointList) {
        int numpoints = Array.getLength(pointList);
        for (int t = 0; t < numpoints; ++t) {
            Coordinate p = pointList[t];
            if (testPoint.x != p.x || testPoint.y != p.y || testPoint.z != p.z && testPoint.z == testPoint.z) continue;
            return true;
        }
        return false;
    }

    @Override
    public Geometry read(EndianDataInputStream file, GeometryFactory geometryFactory, int contentLength) throws IOException, InvalidShapefileException {
        int i;
        int fullLength;
        int t;
        int actualReadWords = 0;
        int shapeType = file.readIntLE();
        actualReadWords += 2;
        if (shapeType == 0) {
            return new MultiPolygon(null, new PrecisionModel(), 0);
        }
        if (shapeType != this.myShapeType) {
            throw new InvalidShapefileException("PolygonHandler.read() - got shape type " + shapeType + " but was expecting " + this.myShapeType);
        }
        file.readDoubleLE();
        file.readDoubleLE();
        file.readDoubleLE();
        file.readDoubleLE();
        actualReadWords += 16;
        int numParts = file.readIntLE();
        int numPoints = file.readIntLE();
        actualReadWords += 4;
        int[] partOffsets = new int[numParts];
        for (int i2 = 0; i2 < numParts; ++i2) {
            partOffsets[i2] = file.readIntLE();
            actualReadWords += 2;
        }
        ArrayList<LinearRing> shells = new ArrayList<LinearRing>();
        ArrayList<LinearRing> holes = new ArrayList<LinearRing>();
        Coordinate[] coords = new Coordinate[numPoints];
        for (t = 0; t < numPoints; ++t) {
            coords[t] = new Coordinate(file.readDoubleLE(), file.readDoubleLE());
            actualReadWords += 8;
        }
        if (this.myShapeType == 15) {
            file.readDoubleLE();
            file.readDoubleLE();
            actualReadWords += 8;
            for (t = 0; t < numPoints; ++t) {
                coords[t].z = file.readDoubleLE();
                actualReadWords += 4;
            }
        }
        if (this.myShapeType >= 15 && contentLength >= (fullLength = this.myShapeType == 15 ? 22 + 2 * numParts + 8 * numPoints + 8 + 4 * numPoints + 8 + 4 * numPoints : 22 + 2 * numParts + 8 * numPoints + 8 + 4 * numPoints)) {
            file.readDoubleLE();
            file.readDoubleLE();
            actualReadWords += 8;
            for (int t2 = 0; t2 < numPoints; ++t2) {
                file.readDoubleLE();
                actualReadWords += 4;
            }
        }
        while (actualReadWords < contentLength) {
            short junk = file.readShortBE();
            ++actualReadWords;
        }
        int offset = 0;
        for (int part = 0; part < numParts; ++part) {
            int start = partOffsets[part];
            int finish = part == numParts - 1 ? numPoints : partOffsets[part + 1];
            int length = finish - start;
            Coordinate[] points = new Coordinate[length];
            for (int i3 = 0; i3 < length; ++i3) {
                points[i3] = coords[offset];
                ++offset;
            }
            LinearRing ring = geometryFactory.createLinearRing(points);
            if (CGAlgorithms.isCCW((Coordinate[])points)) {
                holes.add(ring);
                continue;
            }
            shells.add(ring);
        }
        ArrayList holesForShells = new ArrayList(shells.size());
        for (i = 0; i < shells.size(); ++i) {
            holesForShells.add(new ArrayList());
        }
        for (i = 0; i < holes.size(); ++i) {
            LinearRing testRing = (LinearRing)holes.get(i);
            LinearRing minShell = null;
            Envelope minEnv = null;
            Envelope testEnv = testRing.getEnvelopeInternal();
            Coordinate testPt = testRing.getCoordinateN(0);
            for (int j = 0; j < shells.size(); ++j) {
                LinearRing tryRing = (LinearRing)shells.get(j);
                Envelope tryEnv = tryRing.getEnvelopeInternal();
                if (minShell != null) {
                    minEnv = minShell.getEnvelopeInternal();
                }
                boolean isContained = false;
                Coordinate[] coordList = tryRing.getCoordinates();
                if (tryEnv.contains(testEnv)) {
                    if (CGAlgorithms.isPointInRing((Coordinate)testPt, (Coordinate[])coordList) || this.pointInList(testPt, coordList)) {
                        isContained = true;
                    }
                }
                if (!isContained || minShell != null && !minEnv.contains(tryEnv)) continue;
                minShell = tryRing;
            }
            if (minShell == null) {
                System.out.println("polygon found with a hole thats not inside a shell");
                continue;
            }
            ((ArrayList)holesForShells.get(shells.indexOf(minShell))).add(testRing);
        }
        Polygon[] polygons = new Polygon[shells.size()];
        for (int i4 = 0; i4 < shells.size(); ++i4) {
            polygons[i4] = geometryFactory.createPolygon((LinearRing)shells.get(i4), ((ArrayList)holesForShells.get(i4)).toArray(new LinearRing[0]));
        }
        if (polygons.length == 1) {
            return polygons[0];
        }
        holesForShells = null;
        shells = null;
        holes = null;
        MultiPolygon result = geometryFactory.createMultiPolygon(polygons);
        return result;
    }

    @Override
    public void write(Geometry geometry, EndianDataOutputStream file) throws IOException {
        int t;
        MultiPolygon multi = geometry instanceof MultiPolygon ? (MultiPolygon)geometry : new MultiPolygon(new Polygon[]{(Polygon)geometry}, geometry.getPrecisionModel(), geometry.getSRID());
        file.writeIntLE(this.getShapeType());
        Envelope box = multi.getEnvelopeInternal();
        file.writeDoubleLE(box.getMinX());
        file.writeDoubleLE(box.getMinY());
        file.writeDoubleLE(box.getMaxX());
        file.writeDoubleLE(box.getMaxY());
        int nrings = 0;
        for (int t2 = 0; t2 < multi.getNumGeometries(); ++t2) {
            Polygon p = (Polygon)multi.getGeometryN(t2);
            nrings = nrings + 1 + p.getNumInteriorRing();
        }
        int u = 0;
        int[] pointsPerRing = new int[nrings];
        for (int t3 = 0; t3 < multi.getNumGeometries(); ++t3) {
            Polygon p = (Polygon)multi.getGeometryN(t3);
            pointsPerRing[u] = p.getExteriorRing().getNumPoints();
            ++u;
            for (int v = 0; v < p.getNumInteriorRing(); ++v) {
                pointsPerRing[u] = p.getInteriorRingN(v).getNumPoints();
                ++u;
            }
        }
        int npoints = multi.getNumPoints();
        file.writeIntLE(nrings);
        file.writeIntLE(npoints);
        int count = 0;
        for (int t4 = 0; t4 < nrings; ++t4) {
            file.writeIntLE(count);
            count += pointsPerRing[t4];
        }
        Coordinate[] coords = multi.getCoordinates();
        int num = Array.getLength(coords);
        for (t = 0; t < num; ++t) {
            file.writeDoubleLE(coords[t].x);
            file.writeDoubleLE(coords[t].y);
        }
        if (this.myShapeType == 15) {
            double[] zExtreame = this.zMinMax((Geometry)multi);
            if (Double.isNaN(zExtreame[0])) {
                file.writeDoubleLE(0.0);
                file.writeDoubleLE(0.0);
            } else {
                file.writeDoubleLE(zExtreame[0]);
                file.writeDoubleLE(zExtreame[1]);
            }
            for (int t5 = 0; t5 < npoints; ++t5) {
                double z = coords[t5].z;
                if (Double.isNaN(z)) {
                    file.writeDoubleLE(0.0);
                    continue;
                }
                file.writeDoubleLE(z);
            }
        }
        if (this.myShapeType >= 15) {
            file.writeDoubleLE(-1.0E41);
            file.writeDoubleLE(-1.0E41);
            for (t = 0; t < npoints; ++t) {
                file.writeDoubleLE(-1.0E41);
            }
        }
    }

    @Override
    public int getShapeType() {
        return this.myShapeType;
    }

    @Override
    public int getLength(Geometry geometry) {
        MultiPolygon multi = geometry instanceof MultiPolygon ? (MultiPolygon)geometry : new MultiPolygon(new Polygon[]{(Polygon)geometry}, geometry.getPrecisionModel(), geometry.getSRID());
        int nrings = 0;
        for (int t = 0; t < multi.getNumGeometries(); ++t) {
            Polygon p = (Polygon)multi.getGeometryN(t);
            nrings = nrings + 1 + p.getNumInteriorRing();
        }
        int npoints = multi.getNumPoints();
        if (this.myShapeType == 15) {
            return 22 + 2 * nrings + 8 * npoints + 4 * npoints + 8 + 4 * npoints + 8;
        }
        if (this.myShapeType == 25) {
            return 22 + 2 * nrings + 8 * npoints + 4 * npoints + 8;
        }
        return 22 + 2 * nrings + 8 * npoints;
    }

    double[] zMinMax(Geometry g) {
        boolean validZFound = false;
        Coordinate[] cs = g.getCoordinates();
        double[] result = new double[2];
        double zmin = Double.NaN;
        double zmax = Double.NaN;
        for (int t = 0; t < cs.length; ++t) {
            double z = cs[t].z;
            if (Double.isNaN(z)) continue;
            if (validZFound) {
                if (z < zmin) {
                    zmin = z;
                }
                if (!(z > zmax)) continue;
                zmax = z;
                continue;
            }
            validZFound = true;
            zmin = z;
            zmax = z;
        }
        result[0] = zmin;
        result[1] = zmax;
        return result;
    }
}

