/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.coordsys.impl;

import org.locationtech.jts.jump.coordsys.CoordinateSystem;
import org.locationtech.jts.jump.coordsys.Radius;
import org.locationtech.jts.jump.coordsys.Spheroid;
import org.locationtech.jts.jump.coordsys.impl.Albers;
import org.locationtech.jts.jump.coordsys.impl.LatLong;
import org.locationtech.jts.jump.coordsys.impl.UniversalTransverseMercator;
import org.locationtech.jts.util.Assert;

public class PredefinedCoordinateSystems {
    public static final CoordinateSystem BC_ALBERS_NAD_83 = new CoordinateSystem("BC Albers / NAD 83", 42102, new Albers(){
        {
            this.setSpheroid(new Spheroid(new Radius(0)));
            this.setParameters(-126.0, 50.0, 58.5, 45.0, 1000000.0, 0.0);
        }
    });
    public static final CoordinateSystem GEOGRAPHICS_WGS_84 = new CoordinateSystem("Geographics / WGS 84", 4326, new LatLong());
    public static final CoordinateSystem UTM_07N_WGS_84 = PredefinedCoordinateSystems.createUTMNorth(7);
    public static final CoordinateSystem UTM_08N_WGS_84 = PredefinedCoordinateSystems.createUTMNorth(8);
    public static final CoordinateSystem UTM_09N_WGS_84 = PredefinedCoordinateSystems.createUTMNorth(9);
    public static final CoordinateSystem UTM_10N_WGS_84 = PredefinedCoordinateSystems.createUTMNorth(10);
    public static final CoordinateSystem UTM_11N_WGS_84 = PredefinedCoordinateSystems.createUTMNorth(11);

    private PredefinedCoordinateSystems() {
    }

    private static CoordinateSystem createUTMNorth(final int zone) {
        Assert.isTrue((1 <= zone && zone <= 60 ? 1 : 0) != 0);
        return new CoordinateSystem("UTM " + (zone < 10 ? "0" : "") + zone + "N / WGS 84", 32600 + zone, new UniversalTransverseMercator(){
            {
                this.setSpheroid(new Spheroid(new Radius(0)));
                this.setParameters(zone);
            }
        });
    }

    public static CoordinateSystem getCoordinateSystem(int epsgCode) {
        CoordinateSystem cs = null;
        if (epsgCode == GEOGRAPHICS_WGS_84.getEPSGCode()) {
            cs = GEOGRAPHICS_WGS_84;
        } else if (epsgCode == BC_ALBERS_NAD_83.getEPSGCode()) {
            cs = BC_ALBERS_NAD_83;
        } else if (epsgCode == UTM_07N_WGS_84.getEPSGCode()) {
            cs = UTM_07N_WGS_84;
        } else if (epsgCode == UTM_08N_WGS_84.getEPSGCode()) {
            cs = UTM_08N_WGS_84;
        } else if (epsgCode == UTM_09N_WGS_84.getEPSGCode()) {
            cs = UTM_09N_WGS_84;
        } else if (epsgCode == UTM_10N_WGS_84.getEPSGCode()) {
            cs = UTM_10N_WGS_84;
        } else if (epsgCode == UTM_11N_WGS_84.getEPSGCode()) {
            cs = UTM_11N_WGS_84;
        }
        return cs;
    }
}

