/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.demo.delineation;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.jump.demo.delineation.DelineationUtil;
import org.locationtech.jts.jump.feature.Feature;
import org.locationtech.jts.jump.workbench.ui.Viewport;
import org.locationtech.jts.jump.workbench.ui.renderer.style.VertexStyle;

public class DelineationVertexStyle
extends VertexStyle {
    public DelineationVertexStyle() {
        super(new Ellipse2D.Double());
    }

    @Override
    public void paint(Feature f, Graphics2D g, Viewport viewport) throws Exception {
        Coordinate[] coordinates = f.getGeometry().getCoordinates();
        DelineationUtil.checkDelineationCoordinates(coordinates);
        g.setColor(this.color(f.getAttribute("SOURCE_SNAPPED").equals("Y")));
        this.paint(g, viewport.toViewPoint(new Point2D.Double(coordinates[0].x, coordinates[0].y)));
        g.setColor(this.color(f.getAttribute("DESTINATION_SNAPPED").equals("Y")));
        this.paint(g, viewport.toViewPoint(new Point2D.Double(coordinates[1].x, coordinates[1].y)));
    }

    private Color color(boolean snapped) {
        return snapped ? Color.green : Color.red;
    }
}

