/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.demo.delineation;

import java.awt.Cursor;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.Collection;
import javax.swing.Icon;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.jump.demo.delineation.DelineationUtil;
import org.locationtech.jts.jump.feature.Feature;
import org.locationtech.jts.jump.workbench.model.Layer;
import org.locationtech.jts.jump.workbench.ui.cursortool.DragTool;

public class EditDelineationTool
extends DragTool {
    private static final int TOLERANCE = 5;
    private Feature delineationBeingEdited;
    private String snappedAttributeName;
    private Coordinate stationaryVertex;
    private Coordinate vertexToMove;

    public EditDelineationTool(Collection snapPolicies) {
        this.getSnapManager().addPolicies(snapPolicies);
        this.setColor(DelineationUtil.TOOL_COLOR);
        this.setStrokeWidth(5);
    }

    @Override
    public Icon getIcon() {
        return DelineationUtil.ICON;
    }

    @Override
    public Cursor getCursor() {
        return DelineationUtil.CURSOR;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        try {
            this.delineationBeingEdited = this.findDelineationWithVertexAt(e.getPoint());
            if (this.delineationBeingEdited == null) {
                return;
            }
            super.mousePressed(e);
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    @Override
    protected Shape getShape(Point2D source, Point2D destination) throws NoninvertibleTransformException {
        return new Line2D.Double(this.getPanel().getViewport().toViewPoint(new Point2D.Double(this.stationaryVertex.x, this.stationaryVertex.y)), destination);
    }

    private Layer delineationLayer() {
        return this.getPanel().getLayerManager().getLayer("Delineations");
    }

    private Feature findDelineationWithVertexAt(Point2D viewPoint) throws Exception {
        if (this.delineationLayer() == null || !this.delineationLayer().isVisible()) {
            return null;
        }
        Collection delineationsWithVertex = this.getPanel().featuresWithVertex(viewPoint, 5.0, this.delineationLayer().getFeatureCollectionWrapper().query(this.getPanel().getViewport().getEnvelopeInModelCoordinates()));
        if (delineationsWithVertex.isEmpty()) {
            return null;
        }
        Feature delineation = (Feature)delineationsWithVertex.iterator().next();
        Coordinate[] coordinates = delineation.getGeometry().getCoordinates();
        DelineationUtil.checkDelineationCoordinates(coordinates);
        Coordinate c = this.getPanel().getViewport().toModelCoordinate(viewPoint);
        if (coordinates[0].distance(c) < coordinates[1].distance(c)) {
            this.stationaryVertex = coordinates[1];
            this.vertexToMove = coordinates[0];
            this.snappedAttributeName = "SOURCE_SNAPPED";
        } else {
            this.stationaryVertex = coordinates[0];
            this.vertexToMove = coordinates[1];
            this.snappedAttributeName = "DESTINATION_SNAPPED";
        }
        return delineation;
    }

    private void moveVertex(Feature delineation, Coordinate finalLocation) throws Exception {
        this.vertexToMove.setCoordinate(finalLocation);
        delineation.getGeometry().geometryChanged();
        delineation.setAttribute(this.snappedAttributeName, (Object)DelineationUtil.toString(this.getSnapManager().wasSnapCoordinateFound()));
    }

    @Override
    protected void gestureFinished() throws Exception {
        this.moveVertex(this.delineationBeingEdited, this.getModelDestination());
        this.delineationLayer().fireAppearanceChanged();
    }
}

