/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.demo.layerviewpanel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.io.File;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.locationtech.jts.jump.workbench.WorkbenchContext;
import org.locationtech.jts.jump.workbench.model.Category;
import org.locationtech.jts.jump.workbench.model.LayerManager;
import org.locationtech.jts.jump.workbench.model.LayerTreeModel;
import org.locationtech.jts.jump.workbench.plugin.MultiEnableCheck;
import org.locationtech.jts.jump.workbench.ui.ErrorHandler;
import org.locationtech.jts.jump.workbench.ui.LayerNamePanel;
import org.locationtech.jts.jump.workbench.ui.LayerViewPanel;
import org.locationtech.jts.jump.workbench.ui.LayerViewPanelContext;
import org.locationtech.jts.jump.workbench.ui.LayerViewPanelListener;
import org.locationtech.jts.jump.workbench.ui.LayerViewPanelProxy;
import org.locationtech.jts.jump.workbench.ui.TreeLayerNamePanel;
import org.locationtech.jts.jump.workbench.ui.WorkbenchToolBar;
import org.locationtech.jts.jump.workbench.ui.cursortool.MeasureTool;
import org.locationtech.jts.jump.workbench.ui.images.IconLoader;
import org.locationtech.jts.jump.workbench.ui.plugin.test.RandomTrianglesPlugIn;
import org.locationtech.jts.jump.workbench.ui.zoom.PanTool;
import org.locationtech.jts.jump.workbench.ui.zoom.ZoomToFullExtentPlugIn;
import org.locationtech.jts.jump.workbench.ui.zoom.ZoomTool;
import org.locationtech.jts.util.Assert;

public class MapTab
extends JPanel
implements LayerViewPanelContext {
    private static final String LAYERS = "Layers";
    private BorderLayout borderLayout1 = new BorderLayout();
    private JLabel statusLabel = new JLabel();
    private ErrorHandler errorHandler;
    private WorkbenchToolBar toolBar = new WorkbenchToolBar(new LayerViewPanelProxy(){

        @Override
        public LayerViewPanel getLayerViewPanel() {
            return MapTab.this.layerViewPanel;
        }
    });
    private LayerManager layerManager = new LayerManager();
    private TreeLayerNamePanel layerNamePanel;
    private JPanel centrePanel = new JPanel();
    private LayerViewPanel layerViewPanel;
    private GridLayout gridLayout1 = new GridLayout();
    private JLabel layerViewPanelLabel = new JLabel();
    private JLabel layerNamePanelLabel = new JLabel();
    private JPanel toolbarPanel = new JPanel();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JLabel toolbarPanelLabel = new JLabel();
    private WorkbenchContext workbenchContext = new WorkbenchContext(){

        @Override
        public ErrorHandler getErrorHandler() {
            return MapTab.this;
        }

        @Override
        public LayerNamePanel getLayerNamePanel() {
            return MapTab.this.layerNamePanel;
        }

        @Override
        public LayerViewPanel getLayerViewPanel() {
            return MapTab.this.layerViewPanel;
        }

        @Override
        public LayerManager getLayerManager() {
            return MapTab.this.layerManager;
        }
    };

    public MapTab(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
        this.layerViewPanel = new LayerViewPanel(this.layerManager, this);
        this.layerNamePanel = new TreeLayerNamePanel(this.layerViewPanel, new LayerTreeModel(this.layerViewPanel), this.layerViewPanel.getRenderingManager(), new HashMap());
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.layerViewPanel.addListener(new LayerViewPanelListener(){

            @Override
            public void painted(Graphics graphics) {
            }

            @Override
            public void selectionChanged() {
            }

            @Override
            public void cursorPositionChanged(String x, String y) {
                MapTab.this.setStatusMessage("(" + x + ", " + y + ")");
            }
        });
    }

    @Override
    public void handleThrowable(Throwable t) {
        this.errorHandler.handleThrowable(t);
    }

    @Override
    public void warnUser(String warning) {
        this.setStatusMessage(warning);
    }

    @Override
    public void setStatusMessage(String message) {
        this.statusLabel.setText(message == null || message.length() == 0 ? " " : message);
    }

    void jbInit() throws Exception {
        this.statusLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.statusLabel.setText(" ");
        this.setLayout(this.borderLayout1);
        this.centrePanel.setLayout(this.gridLayout1);
        this.gridLayout1.setColumns(2);
        this.gridLayout1.setHgap(4);
        this.gridLayout1.setRows(3);
        this.gridLayout1.setVgap(4);
        this.layerViewPanelLabel.setText("<HTML>This is a LayerViewPanel. (It might take a few moments for the data to load). Try moving your mouse over the image and note the coordinates reported on the status bar below.<BR><BR></HTML>");
        this.layerViewPanelLabel.setVerticalAlignment(1);
        this.layerNamePanelLabel.setText("<HTML>And this is a LayerNamePanel. It is independent of the LayerViewPanel above, although they share a common model. Try clicking the checkboxes to turn the layers on and off.<BR><BR>LayerNamePanels can put layers in multiple categories. In this demo there is just one category (\"Layer\").</HTML>");
        this.layerNamePanelLabel.setVerticalAlignment(1);
        this.layerViewPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.layerNamePanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.toolbarPanel.setLayout(this.gridBagLayout1);
        this.toolbarPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.toolbarPanelLabel.setText("<HTML>The WorkbenchToolBar class makes it easy to add CursorTools and PlugIns as toolbar buttons. Here the first three buttons are CursorTools and the fourth is a PlugIn. CursorTools allow the user to interact with the LayerViewPanel; PlugIns perform their action immediately.<BR><BR>Try clicking a button and seeing what it does to the LayerViewPanel above.<BR><BR>The WorkbenchToolBar adds CursorTools as mutually exclusive toggle buttons. It takes care of ensuring that the currently pressed CursorTool is registered with the LayerViewPanel.</HTML>");
        this.toolbarPanelLabel.setVerticalAlignment(1);
        this.add((Component)this.statusLabel, "South");
        this.add((Component)this.centrePanel, "Center");
        this.centrePanel.add((Component)this.layerViewPanel, null);
        this.centrePanel.add((Component)this.layerViewPanelLabel, null);
        this.centrePanel.add((Component)this.layerNamePanel, null);
        this.centrePanel.add((Component)this.layerNamePanelLabel, null);
        this.centrePanel.add((Component)this.toolbarPanel, null);
        this.centrePanel.add((Component)this.toolbarPanelLabel, null);
        this.toolbarPanel.add((Component)this.toolBar, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void initialize() throws Exception {
        this.toolBar.addCursorTool("Zoom In/Out", new ZoomTool());
        this.toolBar.addCursorTool("Pan", new PanTool());
        this.toolBar.addCursorTool("Measure", new MeasureTool());
        this.toolBar.addSeparator();
        this.toolBar.addPlugIn(IconLoader.icon("World.gif"), new ZoomToFullExtentPlugIn(), new MultiEnableCheck(), this.workbenchContext);
        this.loadData();
    }

    private void loadData() throws Exception {
        this.removeAllCategories(this.layerManager);
        new RandomTrianglesPlugIn().execute(this.workbenchContext.createPlugInContext());
    }

    private File toFile(String filename) {
        String parent = System.getProperty("jump-demo-data-directory");
        Assert.isTrue((parent != null ? 1 : 0) != 0);
        return new File(parent, filename);
    }

    private void removeAllCategories(LayerManager layerManager) {
        for (Category cat : layerManager.getCategories()) {
            layerManager.removeIfEmpty(cat);
        }
    }
}

