/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.feature;

import java.util.Collection;
import java.util.Iterator;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.jump.feature.AttributeType;
import org.locationtech.jts.jump.feature.BasicFeature;
import org.locationtech.jts.jump.feature.FeatureCollection;
import org.locationtech.jts.jump.feature.FeatureDataset;
import org.locationtech.jts.jump.feature.FeatureSchema;

public class FeatureDatasetFactory {
    public static FeatureCollection createFromGeometry(Collection geoms) {
        FeatureSchema featureSchema = new FeatureSchema();
        featureSchema.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
        FeatureDataset fc = new FeatureDataset(featureSchema);
        Iterator i = geoms.iterator();
        while (i.hasNext()) {
            BasicFeature feature = new BasicFeature(fc.getFeatureSchema());
            feature.setGeometry((Geometry)i.next());
            fc.add(feature);
        }
        return fc;
    }

    public static FeatureDataset createFromGeometryWithLength(Collection geoms, String attrName) {
        FeatureSchema featureSchema = new FeatureSchema();
        featureSchema.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
        featureSchema.addAttribute(attrName, AttributeType.DOUBLE);
        FeatureDataset fc = new FeatureDataset(featureSchema);
        Iterator i = geoms.iterator();
        while (i.hasNext()) {
            BasicFeature feature = new BasicFeature(fc.getFeatureSchema());
            Geometry g = (Geometry)i.next();
            feature.setGeometry(g);
            feature.setAttribute(attrName, (Object)new Double(g.getLength()));
            fc.add(feature);
        }
        return fc;
    }
}

