/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.feature;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import org.locationtech.jts.jump.coordsys.CoordinateSystem;
import org.locationtech.jts.jump.feature.AttributeType;
import org.locationtech.jts.util.Assert;

public class FeatureSchema
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -8627306219650589202L;
    private CoordinateSystem coordinateSystem = CoordinateSystem.UNSPECIFIED;
    private HashMap attributeNameToIndexMap = new HashMap();
    private int geometryIndex = -1;
    private int attributeCount = 0;
    private ArrayList attributeNames = new ArrayList();
    private ArrayList attributeTypes = new ArrayList();

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            Assert.shouldNeverReachHere();
            return null;
        }
    }

    public int getAttributeIndex(String attributeName) {
        Integer index = (Integer)this.attributeNameToIndexMap.get(attributeName);
        if (index == null) {
            throw new IllegalArgumentException("Unrecognized attribute name: " + attributeName);
        }
        return index;
    }

    public boolean hasAttribute(String attributeName) {
        return this.attributeNameToIndexMap.get(attributeName) != null;
    }

    public int getGeometryIndex() {
        return this.geometryIndex;
    }

    public String getAttributeName(int attributeIndex) {
        return (String)this.attributeNames.get(attributeIndex);
    }

    public AttributeType getAttributeType(int attributeIndex) {
        return (AttributeType)this.attributeTypes.get(attributeIndex);
    }

    public AttributeType getAttributeType(String attributeName) {
        return this.getAttributeType(this.getAttributeIndex(attributeName));
    }

    public int getAttributeCount() {
        return this.attributeCount;
    }

    public void addAttribute(String attributeName, AttributeType attributeType) {
        if (AttributeType.GEOMETRY == attributeType) {
            Assert.isTrue((this.geometryIndex == -1 ? 1 : 0) != 0);
            this.geometryIndex = this.attributeCount;
        }
        this.attributeNames.add(attributeName);
        this.attributeNameToIndexMap.put(attributeName, new Integer(this.attributeCount));
        this.attributeTypes.add(attributeType);
        ++this.attributeCount;
    }

    public boolean equals(Object other) {
        return this.equals(other, false);
    }

    public boolean equals(Object other, boolean orderMatters) {
        if (!(other instanceof FeatureSchema)) {
            return false;
        }
        FeatureSchema otherFeatureSchema = (FeatureSchema)other;
        if (this.attributeNames.size() != otherFeatureSchema.attributeNames.size()) {
            return false;
        }
        for (int i = 0; i < this.attributeNames.size(); ++i) {
            String attributeName = (String)this.attributeNames.get(i);
            if (!otherFeatureSchema.attributeNames.contains(attributeName)) {
                return false;
            }
            if (orderMatters && !otherFeatureSchema.attributeNames.get(i).equals(attributeName)) {
                return false;
            }
            if (this.getAttributeType(attributeName) == otherFeatureSchema.getAttributeType(attributeName)) continue;
            return false;
        }
        return true;
    }

    public FeatureSchema setCoordinateSystem(CoordinateSystem coordinateSystem) {
        this.coordinateSystem = coordinateSystem;
        return this;
    }

    public CoordinateSystem getCoordinateSystem() {
        return this.coordinateSystem;
    }
}

