/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.io;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import org.locationtech.jts.jump.feature.FeatureCollection;
import org.locationtech.jts.jump.io.CompressedFile;
import org.locationtech.jts.jump.io.DriverProperties;
import org.locationtech.jts.jump.io.GMLInputTemplate;
import org.locationtech.jts.jump.io.GMLReader;
import org.locationtech.jts.jump.io.IllegalParametersException;
import org.locationtech.jts.jump.io.JUMPReader;
import org.locationtech.jts.jump.io.ParseException;

public class FMEGMLReader
implements JUMPReader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FeatureCollection read(DriverProperties dp) throws IllegalParametersException, Exception {
        FeatureCollection result;
        GMLInputTemplate inputTemplate;
        GMLReader gmlReader = new GMLReader();
        boolean isCompressed = dp.getProperty("CompressedFile") != null;
        String inputfname = dp.getProperty("DefaultValue");
        if (inputfname == null) {
            inputfname = dp.getProperty("File");
        }
        if (inputfname == null) {
            throw new IllegalParametersException("call to FMEReader.read() has DataProperties w/o a InputFile specified");
        }
        try (BufferedReader r = isCompressed ? new BufferedReader(new InputStreamReader(CompressedFile.openFile(inputfname, dp.getProperty("CompressedFile")))) : new BufferedReader(new FileReader(inputfname));){
            try {
                inputTemplate = this.getGMLInputTemplate(r, inputfname);
            }
            finally {
                ((Reader)r).close();
            }
        }
        r = isCompressed ? new BufferedReader(new InputStreamReader(CompressedFile.openFile(inputfname, dp.getProperty("CompressedFile")))) : new BufferedReader(new FileReader(inputfname));
        try {
            gmlReader.setInputTemplate(inputTemplate);
            try {
                result = gmlReader.read(r, inputfname);
            }
            finally {
                ((Reader)r).close();
            }
        }
        finally {
            ((Reader)r).close();
        }
        return result;
    }

    public GMLInputTemplate getGMLInputTemplate(Reader r, String fname) throws IOException, ParseException {
        String columnDef;
        String s;
        LineNumberReader reader = new LineNumberReader(r);
        boolean foundStartTag = false;
        boolean foundEndTag = false;
        for (int lineNo = 0; !foundStartTag && lineNo < 10; ++lineNo) {
            s = reader.readLine();
            if (s != null) continue;
            throw new ParseException("Couldn't find a <schemaFeatures> tag in the input FME GML file.  This isn't a valid FME GML file.");
        }
        if (!foundStartTag) {
            throw new ParseException("Read first 10 lines of " + fname + " and couldn't find a <schemaFeatures> tag.  This isn't a valid FME GML file.");
        }
        String columns = "";
        while (!foundEndTag) {
            s = reader.readLine();
            if (s.indexOf("</schemaFeatures>") > -1) {
                foundEndTag = true;
            }
            if (s.indexOf("<property fme:name") == -1 && s.indexOf("<property name") == -1) continue;
            String propertyNamePrefix = "";
            if (s.indexOf("<property fme:name") != -1) {
                propertyNamePrefix = "fme:";
            }
            int start = s.indexOf("\"");
            int end = s.indexOf("\"", start + 1);
            if (start == -1 || end == -1) {
                throw new ParseException("Parsing file " + fname + " couldn't get column name on line # " + reader.getLineNumber() + " - " + s);
            }
            String columnName = s.substring(start + 1, end);
            start = s.indexOf(">");
            end = s.indexOf("<", start + 1);
            if (start == -1 || end == -1) {
                throw new ParseException("Parsing file " + fname + " couldn't get column type on line # " + reader.getLineNumber() + " - " + s);
            }
            String columnType = this.FMEtypeToJCSType(s.substring(start + 1, end));
            columnDef = "     <column>\n     <name>" + columnName + "</name>\n          <type>" + columnType + "</type>\n";
            columnDef = columnDef + "         <valueElement elementName=\"property\" attributeName=\"" + propertyNamePrefix + "name\" attributeValue=\"" + columnName + "\" />\n";
            columnDef = columnDef + "         <valueLocation position=\"body\" />\n";
            columnDef = columnDef + "     </column>\n";
            columns = columns + columnDef;
        }
        columnDef = "     <column>\n     <name>featuretype</name>\n";
        columnDef = columnDef + "           <type>STRING</type>\n";
        columnDef = columnDef + "           <valueElement elementName=\"featureType\"/>\n";
        columnDef = columnDef + "           <valueLocation position=\"body\"/>\n";
        columnDef = columnDef + "     </column>\n";
        columns = columns + columnDef;
        String templateText = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n";
        templateText = templateText + "<JCSGMLInputTemplate>\n";
        templateText = templateText + "     <CollectionElement>dataFeatures</CollectionElement>\n";
        templateText = templateText + "     <FeatureElement>Feature</FeatureElement>\n";
        templateText = templateText + "     <GeometryElement>gml:PointProperty</GeometryElement>\n";
        templateText = templateText + "     <GeometryElement>gml:PolygonProperty</GeometryElement>\n";
        templateText = templateText + "     <GeometryElement>gml:LineStringProperty</GeometryElement>\n";
        templateText = templateText + "     <GeometryElement>gml:MultiPointProperty</GeometryElement>\n";
        templateText = templateText + "     <GeometryElement>gml:MultiPolygonProperty</GeometryElement>\n";
        templateText = templateText + "     <GeometryElement>gml:MultiLineStringProperty</GeometryElement>\n";
        templateText = templateText + "     <GeometryElement>gml:MultiGeometryProperty</GeometryElement>\n";
        templateText = templateText + "     <ColumnDefinitions>\n";
        templateText = templateText + columns;
        templateText = templateText + "     </ColumnDefinitions>\n";
        templateText = templateText + "</JCSGMLInputTemplate>\n";
        StringReader sr = new StringReader(templateText);
        GMLInputTemplate result = new GMLInputTemplate();
        result.load(sr, "Auto created FME GML input template");
        sr.close();
        return result;
    }

    String FMEtypeToJCSType(String fmeType) {
        if (fmeType.indexOf("fme_char") > -1) {
            return "STRING";
        }
        if (fmeType.indexOf("fme_decimal") > -1) {
            int loc = fmeType.indexOf(",");
            if (loc == -1 || loc == fmeType.length() - 1) {
                return "STRING";
            }
            if (fmeType.substring(loc + 1, loc + 2).equalsIgnoreCase("0")) {
                return "INTEGER";
            }
            return "DOUBLE";
        }
        if (fmeType.indexOf("long") > -1) {
            return "DOUBLE";
        }
        return "STRING";
    }
}

