/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.io.datasource;

import java.util.HashMap;
import java.util.Map;
import org.locationtech.jts.jump.coordsys.CoordinateSystem;
import org.locationtech.jts.jump.coordsys.CoordinateSystemRegistry;
import org.locationtech.jts.jump.feature.FeatureCollection;
import org.locationtech.jts.jump.io.datasource.Connection;

public abstract class DataSource {
    private HashMap properties;
    public static final String FILE_KEY = "File";
    public static final String COORDINATE_SYSTEM_KEY = "Coordinate System";

    public void setProperties(Map properties) {
        this.properties = new HashMap(properties);
    }

    public Map getProperties() {
        return this.properties;
    }

    public abstract Connection getConnection();

    public boolean isReadable() {
        return true;
    }

    public boolean isWritable() {
        return true;
    }

    public FeatureCollection installCoordinateSystem(FeatureCollection queryResult, CoordinateSystemRegistry registry) {
        if (queryResult == null) {
            return queryResult;
        }
        String coordinateSystemName = (String)this.getProperties().get(COORDINATE_SYSTEM_KEY);
        if (coordinateSystemName == null) {
            return queryResult;
        }
        CoordinateSystem coordinateSystem = registry.get(coordinateSystemName);
        if (coordinateSystem == null) {
            return queryResult;
        }
        queryResult.getFeatureSchema().setCoordinateSystem(coordinateSystem);
        return queryResult;
    }
}

