/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.io.datasource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.locationtech.jts.jump.feature.FeatureCollection;
import org.locationtech.jts.jump.io.DriverProperties;
import org.locationtech.jts.jump.io.JUMPReader;
import org.locationtech.jts.jump.io.JUMPWriter;
import org.locationtech.jts.jump.io.datasource.Connection;
import org.locationtech.jts.jump.io.datasource.DataSource;
import org.locationtech.jts.jump.task.TaskMonitor;

public class ReaderWriterFileDataSource
extends DataSource {
    protected JUMPReader reader;
    protected JUMPWriter writer;

    public ReaderWriterFileDataSource(JUMPReader reader, JUMPWriter writer) {
        this.reader = reader;
        this.writer = writer;
    }

    @Override
    public Connection getConnection() {
        return new Connection(){

            @Override
            public FeatureCollection executeQuery(String query, Collection exceptions, TaskMonitor monitor) {
                try {
                    return ReaderWriterFileDataSource.this.reader.read(ReaderWriterFileDataSource.this.getReaderDriverProperties());
                }
                catch (Exception e) {
                    exceptions.add(e);
                    return null;
                }
            }

            @Override
            public void executeUpdate(String update, FeatureCollection featureCollection, TaskMonitor monitor) throws Exception {
                ReaderWriterFileDataSource.this.writer.write(featureCollection, ReaderWriterFileDataSource.this.getWriterDriverProperties());
            }

            @Override
            public void close() {
            }

            @Override
            public FeatureCollection executeQuery(String query, TaskMonitor monitor) throws Exception {
                ArrayList exceptions = new ArrayList();
                FeatureCollection featureCollection = this.executeQuery(query, exceptions, monitor);
                if (!exceptions.isEmpty()) {
                    throw (Exception)exceptions.iterator().next();
                }
                return featureCollection;
            }
        };
    }

    protected DriverProperties getReaderDriverProperties() {
        return this.getDriverProperties();
    }

    protected DriverProperties getWriterDriverProperties() {
        return this.getDriverProperties();
    }

    private DriverProperties getDriverProperties() {
        DriverProperties properties = new DriverProperties();
        properties.putAll((Map<?, ?>)this.getProperties());
        return properties;
    }
}

