/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.io.datasource;

import java.util.Arrays;
import java.util.Collection;
import org.locationtech.jts.jump.feature.FeatureCollection;
import org.locationtech.jts.jump.io.DriverProperties;
import org.locationtech.jts.jump.io.FMEGMLReader;
import org.locationtech.jts.jump.io.FMEGMLWriter;
import org.locationtech.jts.jump.io.GMLReader;
import org.locationtech.jts.jump.io.GMLWriter;
import org.locationtech.jts.jump.io.JMLReader;
import org.locationtech.jts.jump.io.JMLWriter;
import org.locationtech.jts.jump.io.JUMPReader;
import org.locationtech.jts.jump.io.JUMPWriter;
import org.locationtech.jts.jump.io.ShapefileReader;
import org.locationtech.jts.jump.io.ShapefileWriter;
import org.locationtech.jts.jump.io.WKTReader;
import org.locationtech.jts.jump.io.WKTWriter;
import org.locationtech.jts.jump.io.datasource.DelegatingCompressedFileHandler;
import org.locationtech.jts.jump.io.datasource.ReaderWriterFileDataSource;
import org.locationtech.jts.jump.util.Block;
import org.locationtech.jts.jump.util.CollectionUtil;

public abstract class StandardReaderWriterFileDataSource
extends ReaderWriterFileDataSource {
    protected String[] extensions;
    public static final String[] GML_EXTENSIONS = new String[]{"gml", "xml"};
    public static final String OUTPUT_TEMPLATE_FILE_KEY = "Output Template File";
    public static final String INPUT_TEMPLATE_FILE_KEY = "Input Template File";

    public StandardReaderWriterFileDataSource(JUMPReader reader, JUMPWriter writer, String[] extensions) {
        super(reader, writer);
        this.extensions = extensions;
    }

    public String[] getExtensions() {
        return this.extensions;
    }

    private static GMLWriter createGMLWriter() {
        return new GMLWriter();
    }

    private static DelegatingCompressedFileHandler createGMLReader() {
        return new DelegatingCompressedFileHandler(new GMLReader(), StandardReaderWriterFileDataSource.toEndings(GML_EXTENSIONS)){

            @Override
            public FeatureCollection read(DriverProperties dp) throws Exception {
                this.mangle(dp, "TemplateFile", "CompressedFileTemplate", Arrays.asList("_input.xml", ".input", ".template"));
                return super.read(dp);
            }
        };
    }

    public static Collection toEndings(String[] extensions) {
        return CollectionUtil.collect(Arrays.asList(extensions), new Block(){

            @Override
            public Object yield(Object extension) {
                return "." + extension;
            }
        });
    }

    public static class GML
    extends ClassicReaderWriterFileDataSource {
        public GML() {
            super(StandardReaderWriterFileDataSource.createGMLReader(), StandardReaderWriterFileDataSource.createGMLWriter(), GML_EXTENSIONS);
        }

        @Override
        protected DriverProperties getReaderDriverProperties() {
            return super.getReaderDriverProperties().set("TemplateFile", (String)this.getProperties().get(StandardReaderWriterFileDataSource.INPUT_TEMPLATE_FILE_KEY));
        }

        @Override
        protected DriverProperties getWriterDriverProperties() {
            return super.getWriterDriverProperties().set("TemplateFile", (String)this.getProperties().get(StandardReaderWriterFileDataSource.OUTPUT_TEMPLATE_FILE_KEY));
        }

        @Override
        public boolean isReadable() {
            return this.getProperties().containsKey(StandardReaderWriterFileDataSource.INPUT_TEMPLATE_FILE_KEY);
        }

        @Override
        public boolean isWritable() {
            return this.getProperties().containsKey(StandardReaderWriterFileDataSource.OUTPUT_TEMPLATE_FILE_KEY);
        }
    }

    public static class FMEGML
    extends ClassicReaderWriterFileDataSource {
        public FMEGML() {
            super(new FMEGMLReader(), new FMEGMLWriter(), new String[]{"gml", "xml", "fme"});
        }
    }

    public static class Shapefile
    extends ClassicReaderWriterFileDataSource {
        public Shapefile() {
            super(new ShapefileReader(), new ShapefileWriter(), new String[]{"shp"});
        }
    }

    public static class WKT
    extends ClassicReaderWriterFileDataSource {
        public WKT() {
            super(new WKTReader(), new WKTWriter(), new String[]{"wkt", "txt"});
        }
    }

    public static class JML
    extends ClassicReaderWriterFileDataSource {
        public JML() {
            super(new JMLReader(), new JMLWriter(), new String[]{"jml"});
        }
    }

    private static class ClassicReaderWriterFileDataSource
    extends StandardReaderWriterFileDataSource {
        public ClassicReaderWriterFileDataSource(JUMPReader reader, JUMPWriter writer, String[] extensions) {
            super(new DelegatingCompressedFileHandler(reader, ClassicReaderWriterFileDataSource.toEndings(extensions)), writer, extensions);
            this.extensions = extensions;
        }
    }
}

