/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.locationtech.jts.jump.util.Block;
import org.locationtech.jts.util.Assert;

public class CollectionUtil {
    public static List combinations(List original, int maxCombinationSize) {
        return CollectionUtil.combinations(original, maxCombinationSize, null);
    }

    public static Map inverse(Map map) {
        Map inverse;
        try {
            inverse = (Map)map.getClass().newInstance();
        }
        catch (InstantiationException e) {
            Assert.shouldNeverReachHere((String)e.toString());
            return null;
        }
        catch (IllegalAccessException e) {
            Assert.shouldNeverReachHere((String)e.toString());
            return null;
        }
        for (Object key : map.keySet()) {
            Object value = map.get(key);
            inverse.put(value, key);
        }
        return inverse;
    }

    public static List combinations(List original, int maxCombinationSize, Object mandatoryItem) {
        ArrayList combinations = new ArrayList();
        for (int i = 1; i <= (int)Math.pow(2.0, original.size()) - 1; ++i) {
            ArrayList combination = new ArrayList();
            for (int j = 0; j < original.size(); ++j) {
                if ((i & (int)Math.pow(2.0, j)) <= 0) continue;
                combination.add(original.get(j));
            }
            if (combination.size() > maxCombinationSize || mandatoryItem != null && !combination.contains(mandatoryItem)) continue;
            combinations.add(combination);
        }
        return combinations;
    }

    public static List combinations(List original) {
        return CollectionUtil.combinations(original, original.size(), null);
    }

    public static void removeKeys(Collection keys, Map map) {
        for (Object key : keys) {
            map.remove(key);
        }
    }

    public static List[] keysAndCorrespondingValues(Map map) {
        ArrayList keys = new ArrayList(map.keySet());
        ArrayList values = new ArrayList();
        for (Object key : keys) {
            values.add(map.get(key));
        }
        return new List[]{keys, values};
    }

    public static Collection concatenate(Collection collections) {
        ArrayList concatenation = new ArrayList();
        for (Collection collection : collections) {
            concatenation.addAll(collection);
        }
        return concatenation;
    }

    public static Object randomElement(List list) {
        return list.get((int)Math.floor(Math.random() * (double)list.size()));
    }

    public static SortedSet reverseSortedSet(int[] ints) {
        TreeSet sortedSet = new TreeSet(Collections.reverseOrder());
        for (int i = 0; i < ints.length; ++i) {
            sortedSet.add(new Integer(ints[i]));
        }
        return sortedSet;
    }

    public static List reverse(List list) {
        Collections.reverse(list);
        return list;
    }

    public static Collection stretch(Collection source, Collection destination, int destinationSize) {
        Assert.isTrue((boolean)destination.isEmpty());
        List originalList = source instanceof List ? (List)source : new ArrayList(source);
        for (int i = 0; i < destinationSize; ++i) {
            destination.add(originalList.get((int)Math.round((double)(i * originalList.size()) / (double)destinationSize)));
        }
        return destination;
    }

    public static Object ifNotIn(Object o, Collection c, Object alternative) {
        return c.contains(o) ? o : alternative;
    }

    public static void setIfNull(int i, List list, String value) {
        if (i >= list.size()) {
            CollectionUtil.resize(list, i + 1);
        }
        if (list.get(i) != null) {
            return;
        }
        list.set(i, value);
    }

    public static void resize(List list, int newSize) {
        if (newSize < list.size()) {
            list.subList(newSize, list.size()).clear();
        } else {
            list.addAll(Collections.nCopies(newSize - list.size(), null));
        }
    }

    public static boolean containsReference(Object[] objects, Object o) {
        return CollectionUtil.indexOf(o, objects) > -1;
    }

    public static int indexOf(Object o, Object[] objects) {
        for (int i = 0; i < objects.length; ++i) {
            if (objects[i] != o) continue;
            return i;
        }
        return -1;
    }

    public static Collection removeDuplicates(Collection original) {
        ArrayList result = new ArrayList();
        for (Object item : original) {
            if (result.contains(item)) continue;
            result.add(item);
        }
        return result;
    }

    public static void addIfNotNull(Object item, Collection collection) {
        if (item != null) {
            collection.add(item);
        }
    }

    public static Collection filterByClass(Collection collection, Class c) {
        Iterator i = collection.iterator();
        while (i.hasNext()) {
            Object item = i.next();
            if (c.isInstance(item)) continue;
            i.remove();
        }
        return collection;
    }

    public static Map createMap(Object[] alternatingKeysAndValues) {
        return CollectionUtil.createMap(HashMap.class, alternatingKeysAndValues);
    }

    public static Map createMap(Class mapClass, Object[] alternatingKeysAndValues) {
        Map map = null;
        try {
            map = (Map)mapClass.newInstance();
        }
        catch (Exception e) {
            Assert.shouldNeverReachHere((String)e.toString());
        }
        for (int i = 0; i < alternatingKeysAndValues.length; i += 2) {
            map.put(alternatingKeysAndValues[i], alternatingKeysAndValues[i + 1]);
        }
        return map;
    }

    public static Collection collect(Collection collection, Block block) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object item : collection) {
            result.add(block.yield(item));
        }
        return result;
    }

    public static Collection select(Collection collection, Block block) {
        ArrayList result = new ArrayList();
        for (Object item : collection) {
            if (!Boolean.TRUE.equals(block.yield(item))) continue;
            result.add(item);
        }
        return result;
    }

    public static Object get(Class c, Map map) {
        if (map.keySet().contains(c)) {
            return map.get(c);
        }
        for (Class candidateClass : map.keySet()) {
            if (!candidateClass.isAssignableFrom(c)) continue;
            return map.get(candidateClass);
        }
        return null;
    }
}

