/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.util;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import org.locationtech.jts.jump.util.Fmt;
import org.locationtech.jts.util.Assert;

public class StringUtil {
    public static String s(int n) {
        return n != 1 ? "s" : "";
    }

    public static String ies(int n) {
        return n != 1 ? "ies" : "y";
    }

    public static String classNameWithoutQualifiers(String className) {
        return className.substring(Math.max(className.lastIndexOf("."), className.lastIndexOf("$")) + 1);
    }

    public static String classNameWithoutPackageQualifiers(String className) {
        return className.substring(className.lastIndexOf(".") + 1);
    }

    public static String repeat(char c, int n) {
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            b.append(c);
        }
        return b.toString();
    }

    public static String split(String s, int n) {
        StringBuffer b = new StringBuffer();
        boolean wrapPending = false;
        for (int i = 0; i < s.length(); ++i) {
            if (i % n == 0 && i > 0) {
                wrapPending = true;
            }
            char c = s.charAt(i);
            if (wrapPending && c == ' ') {
                b.append("\n");
                wrapPending = false;
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }

    public static String capitalize(String word) {
        if (word.length() == 0) {
            return word;
        }
        return (word.charAt(0) + "").toUpperCase() + word.substring(1);
    }

    public static String uncapitalize(String word) {
        if (word.length() == 0) {
            return word;
        }
        return (word.charAt(0) + "").toLowerCase() + word.substring(1);
    }

    public static List fromCommaDelimitedString(String s) {
        if (s.trim().length() == 0) {
            return new ArrayList();
        }
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(s, ",");
        while (tokenizer.hasMoreTokens()) {
            result.add(tokenizer.nextToken().toString().trim());
        }
        return result;
    }

    public static List blankStringList(int size) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            list.add("");
        }
        return list;
    }

    public static String toFriendlyName(String className) {
        return StringUtil.toFriendlyName(className, null);
    }

    public static String friendlyName(Class c) {
        return StringUtil.toFriendlyName(c.getName());
    }

    public static String toFriendlyName(String className, String substringToRemove) {
        String name = className;
        if (substringToRemove != null) {
            name = StringUtil.replaceAll(name, substringToRemove, "");
        }
        name = StringUtil.classNameWithoutQualifiers(name);
        name = StringUtil.insertSpaces(name);
        return name;
    }

    public static String insertSpaces(String s) {
        if (s.length() < 2) {
            return s;
        }
        String result = "";
        for (int i = 0; i < s.length() - 2; ++i) {
            result = result + s.charAt(i);
            if ((!Character.isLowerCase(s.charAt(i)) || !Character.isUpperCase(s.charAt(i + 1))) && (!Character.isUpperCase(s.charAt(i + 1)) || !Character.isLowerCase(s.charAt(i + 2)))) continue;
            result = result + " ";
        }
        result = result + s.charAt(s.length() - 2);
        result = result + s.charAt(s.length() - 1);
        return result.trim();
    }

    public static String toCommaDelimitedString(Collection c) {
        return StringUtil.toDelimitedString(c, ", ");
    }

    public static String replaceAll(String original, String oldSubstring, String newSubstring) {
        return StringUtil.replace(original, oldSubstring, newSubstring, true);
    }

    public static String replace(String original, String oldSubstring, String newSubstring, boolean all) {
        StringBuffer b = new StringBuffer(original);
        StringUtil.replace(b, oldSubstring, newSubstring, all);
        return b.toString();
    }

    public static void replace(StringBuffer orig, String o, String n, boolean all) {
        if (orig == null || o == null || o.length() == 0 || n == null) {
            throw new IllegalArgumentException("Null or zero-length String");
        }
        int i = 0;
        while (i + o.length() <= orig.length()) {
            if (orig.substring(i, i + o.length()).equals(o)) {
                orig.replace(i, i + o.length(), n);
                if (!all) break;
                i += n.length();
                continue;
            }
            ++i;
        }
    }

    public static String stackTrace(Throwable t) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(os);
        t.printStackTrace(ps);
        return os.toString();
    }

    public static String head(String s, int lines) {
        int newlinesEncountered = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != '\n' || ++newlinesEncountered != lines) continue;
            return s.substring(0, i);
        }
        return s;
    }

    public static String limitLength(String s, int maxLength) {
        Assert.isTrue((maxLength >= 3 ? 1 : 0) != 0);
        if (s == null) {
            return null;
        }
        if (s.length() > maxLength) {
            return s.substring(0, maxLength - 3) + "...";
        }
        return s;
    }

    public static boolean isNumber(String token) {
        try {
            Double.parseDouble(token);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static String toDelimitedString(Collection c, String delimiter) {
        if (c.isEmpty()) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        for (Object o : c) {
            result.append(delimiter + (o == null ? "" : o.toString()));
        }
        return result.substring(delimiter.length());
    }

    public static String toTimeString(long milliseconds) {
        long remainder = milliseconds;
        long days = remainder / 86400000L;
        long hours = (remainder %= 86400000L) / 3600000L;
        long minutes = (remainder %= 3600000L) / 60000L;
        long seconds = (remainder %= 60000L) / 1000L;
        String s = "";
        if (days > 0L) {
            s = s + days + " days ";
        }
        s = s + Fmt.fmt(hours, 2, 1) + ":" + Fmt.fmt(minutes, 2, 1) + ":" + Fmt.fmt(seconds, 2, 1);
        return s;
    }
}

