/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.warp;

import java.util.Iterator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.jump.JUMPException;
import org.locationtech.jts.jump.feature.Feature;
import org.locationtech.jts.jump.feature.FeatureCollection;
import org.locationtech.jts.jump.feature.FeatureDataset;

public abstract class CoordinateTransform {
    private CoordinateFilter coordinateFilter = new CoordinateFilter(){

        public void filter(Coordinate coordinate) {
            coordinate.setCoordinate(CoordinateTransform.this.transform(coordinate));
        }
    };

    public abstract Coordinate transform(Coordinate var1);

    public FeatureCollection transform(FeatureCollection featureCollection) throws JUMPException {
        FeatureDataset newCollection = new FeatureDataset(featureCollection.getFeatureSchema());
        Iterator i = featureCollection.iterator();
        while (i.hasNext()) {
            Feature feature = (Feature)i.next();
            Geometry newGeometry = this.transform(feature.getGeometry());
            Feature newFeature = feature.clone(false);
            newFeature.setGeometry(newGeometry);
            newCollection.add(newFeature);
        }
        return newCollection;
    }

    public Geometry transform(Geometry oldGeometry) {
        Geometry newGeometry = (Geometry)oldGeometry.clone();
        newGeometry.apply(this.coordinateFilter);
        newGeometry.geometryChanged();
        return newGeometry;
    }
}

