/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.datasource;

import java.awt.Component;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.locationtech.jts.jump.io.datasource.StandardReaderWriterFileDataSource;
import org.locationtech.jts.jump.workbench.datasource.DataSourceQueryChooserManager;
import org.locationtech.jts.jump.workbench.datasource.InstallStandardDataSourceQueryChoosersPlugIn;
import org.locationtech.jts.jump.workbench.datasource.LoadFileDataSourceQueryChooser;
import org.locationtech.jts.jump.workbench.datasource.SaveFileDataSourceQueryChooser;
import org.locationtech.jts.jump.workbench.plugin.PlugInContext;
import org.locationtech.jts.jump.workbench.ui.ErrorHandler;
import org.locationtech.jts.jump.workbench.ui.FileNamePanel;

public class GMLDataSourceQueryChooserInstaller {
    private static final String GML_DESCRIPTION = "GML 2.0";

    public void addSaveGMLFileDataSourceQueryChooser(final PlugInContext context) {
        DataSourceQueryChooserManager.get(context.getWorkbenchContext().getBlackboard()).addSaveDataSourceQueryChooser(new SaveFileDataSourceQueryChooser(StandardReaderWriterFileDataSource.GML.class, GML_DESCRIPTION, InstallStandardDataSourceQueryChoosersPlugIn.extensions(StandardReaderWriterFileDataSource.GML.class), context.getWorkbenchContext()){
            private FileNamePanel templateFileNamePanel;

            @Override
            public boolean isInputValid() {
                return GMLDataSourceQueryChooserInstaller.this.isValid(this.getTemplateFileNamePanel()) && super.isInputValid();
            }

            @Override
            protected Map toProperties(File file) {
                HashMap<String, String> properties = new HashMap<String, String>(super.toProperties(file));
                properties.put("Output Template File", this.getTemplateFileNamePanel().getSelectedFile().getPath());
                return properties;
            }

            private FileNamePanel getTemplateFileNamePanel() {
                if (this.templateFileNamePanel == null) {
                    this.templateFileNamePanel = GMLDataSourceQueryChooserInstaller.this.createTemplateFileNamePanel("Output Template: ", this.getFileChooserPanel().getChooser(), context.getErrorHandler());
                }
                return this.templateFileNamePanel;
            }

            @Override
            protected Component getSouthComponent1() {
                return this.getTemplateFileNamePanel();
            }
        });
    }

    private boolean isValid(FileNamePanel templateFileNamePanel) {
        if (!templateFileNamePanel.isInputValid()) {
            JOptionPane.showMessageDialog(SwingUtilities.windowForComponent(templateFileNamePanel), "Template File: " + templateFileNamePanel.getValidationError(), "Error", 0);
            return false;
        }
        return true;
    }

    public void addLoadGMLFileDataSourceQueryChooser(final PlugInContext context) {
        DataSourceQueryChooserManager.get(context.getWorkbenchContext().getBlackboard()).addLoadDataSourceQueryChooser(new LoadFileDataSourceQueryChooser(StandardReaderWriterFileDataSource.GML.class, GML_DESCRIPTION, InstallStandardDataSourceQueryChoosersPlugIn.extensions(StandardReaderWriterFileDataSource.GML.class), context.getWorkbenchContext()){
            private FileNamePanel templateFileNamePanel;

            @Override
            protected void addFileFilters(JFileChooser chooser) {
                super.addFileFilters(chooser);
                InstallStandardDataSourceQueryChoosersPlugIn.addCompressedFileFilter(GMLDataSourceQueryChooserInstaller.GML_DESCRIPTION, chooser);
            }

            @Override
            public boolean isInputValid() {
                return GMLDataSourceQueryChooserInstaller.this.isValid(this.getTemplateFileNamePanel()) && super.isInputValid();
            }

            @Override
            protected Map toProperties(File file) {
                HashMap<String, String> properties = new HashMap<String, String>(super.toProperties(file));
                properties.put("Input Template File", this.getTemplateFileNamePanel().getSelectedFile().getPath());
                return properties;
            }

            private FileNamePanel getTemplateFileNamePanel() {
                if (this.templateFileNamePanel == null) {
                    this.templateFileNamePanel = GMLDataSourceQueryChooserInstaller.this.createTemplateFileNamePanel("Input Template: ", this.getFileChooserPanel().getChooser(), context.getErrorHandler());
                }
                return this.templateFileNamePanel;
            }

            @Override
            protected Component getSouthComponent1() {
                return this.getTemplateFileNamePanel();
            }
        });
    }

    private FileNamePanel createTemplateFileNamePanel(String description, final JFileChooser fileChooser, ErrorHandler errorHandler) {
        return new TemplateFileNamePanel("Input Template: ", errorHandler){
            {
                super(description, errorHandler);
                this.setFileMustExist(true);
            }

            @Override
            protected File getInitialFile() {
                File initialFile = super.getInitialFile();
                if (!(initialFile.exists() || initialFile.getParent() != null && initialFile.getParentFile().exists())) {
                    return fileChooser.getCurrentDirectory();
                }
                return initialFile;
            }
        };
    }

    private class TemplateFileNamePanel
    extends FileNamePanel {
        public TemplateFileNamePanel(String description, ErrorHandler errorHandler) {
            super(errorHandler);
            this.setUpperDescription("");
            this.setLeftDescription(description);
        }
    }
}

