/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.datasource;

import java.io.File;
import java.util.Collection;
import javax.swing.JFileChooser;
import org.locationtech.jts.jump.coordsys.CoordinateSystemSupport;
import org.locationtech.jts.jump.util.Blackboard;
import org.locationtech.jts.jump.workbench.WorkbenchContext;
import org.locationtech.jts.jump.workbench.datasource.FileDataSourceQueryChooser;
import org.locationtech.jts.jump.workbench.ui.GUIUtil;
import org.locationtech.jts.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;

public class LoadFileDataSourceQueryChooser
extends FileDataSourceQueryChooser {
    private static final String FILE_CHOOSER_DIRECTORY_KEY = LoadFileDataSourceQueryChooser.class.getName() + " - FILE CHOOSER DIRECTORY";
    private static final String FILE_CHOOSER_COORDINATE_SYSTEM_KEY = LoadFileDataSourceQueryChooser.class.getName() + " - FILE CHOOSER COORDINATE SYSTEM";
    private WorkbenchContext context;

    public LoadFileDataSourceQueryChooser(Class dataSourceClass, String description, String[] extensions, WorkbenchContext context) {
        super(dataSourceClass, description, extensions);
        this.context = context;
    }

    private Blackboard blackboard() {
        return this.context.getBlackboard();
    }

    @Override
    protected FileDataSourceQueryChooser.FileChooserPanel getFileChooserPanel() {
        String FILE_CHOOSER_PANEL_KEY = LoadFileDataSourceQueryChooser.class.getName() + " - FILE CHOOSER PANEL";
        if (this.blackboard().get(FILE_CHOOSER_PANEL_KEY) == null) {
            JFileChooser fileChooser = GUIUtil.createJFileChooserWithExistenceChecking();
            fileChooser.setMultiSelectionEnabled(true);
            fileChooser.setControlButtonsAreShown(false);
            this.blackboard().put(FILE_CHOOSER_PANEL_KEY, new FileDataSourceQueryChooser.FileChooserPanel(fileChooser, this.blackboard()));
            if (PersistentBlackboardPlugIn.get(this.context).get(FILE_CHOOSER_DIRECTORY_KEY) != null) {
                fileChooser.setCurrentDirectory(new File((String)PersistentBlackboardPlugIn.get(this.context).get(FILE_CHOOSER_DIRECTORY_KEY)));
                ((FileDataSourceQueryChooser.FileChooserPanel)this.blackboard().get(FILE_CHOOSER_PANEL_KEY)).setSelectedCoordinateSystem((String)PersistentBlackboardPlugIn.get(this.context).get(FILE_CHOOSER_COORDINATE_SYSTEM_KEY));
            }
            if (CoordinateSystemSupport.isEnabled(this.blackboard())) {
                ((FileDataSourceQueryChooser.FileChooserPanel)this.blackboard().get(FILE_CHOOSER_PANEL_KEY)).setCoordinateSystemComboBoxVisible(true);
            }
        }
        return (FileDataSourceQueryChooser.FileChooserPanel)this.blackboard().get(FILE_CHOOSER_PANEL_KEY);
    }

    @Override
    public Collection getDataSourceQueries() {
        PersistentBlackboardPlugIn.get(this.context).put(FILE_CHOOSER_DIRECTORY_KEY, this.getFileChooserPanel().getChooser().getCurrentDirectory().toString());
        PersistentBlackboardPlugIn.get(this.context).put(FILE_CHOOSER_COORDINATE_SYSTEM_KEY, this.getFileChooserPanel().getSelectedCoordinateSystem().getName());
        return super.getDataSourceQueries();
    }
}

